/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command.argument;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.init.ModBase;

public class ArgumentTypeConfigProperty
implements ArgumentType<ConfigurablePropertyData> {
    private final ModBase mod;

    public ArgumentTypeConfigProperty(ModBase mod) {
        this.mod = mod;
    }

    public ModBase getMod() {
        return this.mod;
    }

    public ConfigurablePropertyData parse(StringReader reader) throws CommandSyntaxException {
        ConfigurablePropertyData property = this.mod.getConfigHandler().getCommandableProperties().get(reader.readString());
        if (property == null) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Unknown property")).create();
        }
        return property;
    }

    public Collection<String> getExamples() {
        ArrayList all = Lists.newArrayList(this.mod.getConfigHandler().getCommandableProperties().keySet());
        return all.subList(0, Math.min(all.size(), 3));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(this.mod.getConfigHandler().getCommandableProperties().keySet(), (SuggestionsBuilder)builder);
    }
}

