/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.Strings;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.InfoSectionTagIndex;
import org.cyclops.cyclopscore.infobook.condition.ConfigSectionConditionHandler;
import org.cyclops.cyclopscore.infobook.condition.FluidSectionConditionHandler;
import org.cyclops.cyclopscore.infobook.condition.ISectionConditionHandler;
import org.cyclops.cyclopscore.infobook.condition.ItemSectionConditionHandler;
import org.cyclops.cyclopscore.infobook.condition.ModSectionConditionHandler;
import org.cyclops.cyclopscore.infobook.condition.TagSectionConditionHandler;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewardsAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.CraftingRecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.FurnaceRecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;
import org.cyclops.cyclopscore.infobook.pageelement.IRewardFactory;
import org.cyclops.cyclopscore.infobook.pageelement.ImageAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.KeyBindingAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.RewardItem;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.TextFieldAppendix;
import org.cyclops.cyclopscore.init.ModBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InfoBookParser {
    private static final Map<String, IInfoSectionFactory> SECTION_FACTORIES = Maps.newHashMap();
    private static final Map<String, IAppendixFactory> APPENDIX_FACTORIES = Maps.newHashMap();
    private static final Set<String> IGNORED_APPENDIX_FACTORIES = Sets.newHashSet();
    private static final Map<String, IAppendixListFactory> APPENDIX_LIST_FACTORIES = Maps.newHashMap();
    private static final Map<String, IAppendixItemFactory> APPENDIX_RECIPELIST_FACTORIES = Maps.newHashMap();
    private static final Map<String, IRewardFactory> REWARD_FACTORIES = Maps.newHashMap();
    public static final Map<String, ISectionConditionHandler> RECIPE_CONDITION_HANDLERS = Maps.newHashMap();

    protected static ResourceLocation getNodeResourceLocation(Element node) {
        return new ResourceLocation(node.getTextContent().trim());
    }

    public static void registerSectionFactory(String name, IInfoSectionFactory factory) {
        if (SECTION_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("A section factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerIgnoredFactory(String name) {
        IGNORED_APPENDIX_FACTORIES.add(name);
    }

    public static void registerAppendixFactory(String name, IAppendixFactory factory) {
        if (APPENDIX_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("An appendix factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerAppendixItemFactory(String name, IAppendixItemFactory factory) {
        if (APPENDIX_RECIPELIST_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("An appendix item factory with name %s was registered while another one already existed!", name));
        }
    }

    public static <C extends Container, R extends Recipe<C>> void registerAppendixRecipeFactories(RecipeType<R> recipeType, IAppendixItemFactory<C, R> factory) {
        String name = ForgeRegistries.RECIPE_TYPES.getKey(recipeType).toString();
        InfoBookParser.registerAppendixFactory(name, (infoBook, node) -> {
            Optional recipe;
            ResourceLocation recipeId = InfoBookParser.getNodeResourceLocation(node);
            Optional optional = recipe = MinecraftHelpers.isClientSide() ? CraftingHelpers.getClientRecipe(recipeType, recipeId) : CraftingHelpers.getServerRecipe(recipeType, recipeId);
            if (!recipe.isPresent()) {
                throw new InvalidAppendixException("Could not find " + name + " recipe for " + String.valueOf(recipeId));
            }
            return factory.create(infoBook, (Recipe)recipe.get());
        });
        InfoBookParser.registerAppendixItemFactory(name, factory);
    }

    public static void registerAppendixListFactory(String name, IAppendixListFactory factory) {
        if (APPENDIX_LIST_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("An appendix item factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerAppendixRewardFactory(String name, IRewardFactory factory) {
        if (REWARD_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("A reward factory with name %s was registered while another one already existed!", name));
        }
    }

    public static int getIndex(Element node) {
        int index = 0;
        if (!node.getAttribute("index").isEmpty()) {
            index = Integer.parseInt(node.getAttribute("index"));
        }
        return index;
    }

    public static ItemStack createStack(Element node) throws InvalidAppendixException {
        int amount = 1;
        if (!node.getAttribute("amount").isEmpty()) {
            amount = Integer.parseInt(node.getAttribute("amount"));
        }
        if ("true".equals(node.getAttribute("predefined"))) {
            throw new UnsupportedOperationException("Could not find predefined item " + node.getTextContent());
        }
        ResourceLocation itemId = InfoBookParser.getNodeResourceLocation(node);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (item == null) {
            throw new InvalidAppendixException("Invalid item " + String.valueOf(itemId));
        }
        return new ItemStack((ItemLike)item, amount);
    }

    public static NonNullList<ItemStack> createStacksFromIngredient(Element ingredientNode) throws InvalidAppendixException {
        NonNullList stacks = NonNullList.m_122779_();
        NodeList nodes = ingredientNode.getElementsByTagName("item");
        for (int i = 0; i < nodes.getLength(); ++i) {
            stacks.add((Object)InfoBookParser.createStack((Element)nodes.item(i)));
        }
        return stacks;
    }

    public static ItemStack createStackFromIngredient(Element ingredientNode) throws InvalidAppendixException {
        NonNullList<ItemStack> stacks = InfoBookParser.createStacksFromIngredient(ingredientNode);
        if (stacks.size() != 1) {
            throw new InvalidAppendixException("At least one item node is required");
        }
        return (ItemStack)stacks.get(0);
    }

    public static ItemStack createOptionalStackFromIngredient(Element ingredientNode) {
        return InfoBookParser.invalidAppendixExceptionThrowableOr(() -> InfoBookParser.createStackFromIngredient(ingredientNode), ItemStack.f_41583_);
    }

    public static NonNullList<ItemStack> createOptionalStacksFromIngredient(Element ingredientNode) {
        NonNullList stacks = NonNullList.m_122779_();
        NodeList nodes = ingredientNode.getElementsByTagName("item");
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                stacks.add((Object)InfoBookParser.createStackFromIngredient((Element)nodes.item(i)));
                continue;
            }
            catch (InvalidAppendixException invalidAppendixException) {
                // empty catch block
            }
        }
        return stacks;
    }

    public static Ingredient createIngredient(Element node) throws InvalidAppendixException {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{InfoBookParser.createStack(node)});
    }

    public static NonNullList<Ingredient> createIngredientsFromIngredient(Element ingredientNode) throws InvalidAppendixException {
        NonNullList ingredients = NonNullList.m_122779_();
        NodeList nodes = ingredientNode.getElementsByTagName("item");
        for (int i = 0; i < nodes.getLength(); ++i) {
            ingredients.add((Object)InfoBookParser.createIngredient((Element)nodes.item(i)));
        }
        return ingredients;
    }

    public static Ingredient createOptionalIngredientFromIngredient(Element ingredientNode) {
        return InfoBookParser.invalidAppendixExceptionThrowableOr(() -> InfoBookParser.createIngredientFromIngredient(ingredientNode), Ingredient.f_43901_);
    }

    public static NonNullList<Ingredient> createOptionalIngredientsFromIngredient(Element ingredientNode) {
        NonNullList ingredients = NonNullList.m_122779_();
        NodeList nodes = ingredientNode.getElementsByTagName("item");
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                ingredients.add((Object)InfoBookParser.createIngredientFromIngredient((Element)nodes.item(i)));
                continue;
            }
            catch (InvalidAppendixException invalidAppendixException) {
                // empty catch block
            }
        }
        return ingredients;
    }

    public static Ingredient createIngredientFromIngredient(Element ingredientNode) throws InvalidAppendixException {
        NonNullList<Ingredient> ingredients = InfoBookParser.createIngredientsFromIngredient(ingredientNode);
        if (ingredients.size() != 1) {
            throw new InvalidAppendixException("At least one item node is required");
        }
        return (Ingredient)ingredients.get(0);
    }

    public static FluidStack createFluidStack(Element node) throws InvalidAppendixException {
        ResourceLocation fluidId;
        Fluid fluid;
        int amount = 1000;
        if (!node.getAttribute("amount").isEmpty()) {
            amount = Integer.parseInt(node.getAttribute("amount"));
        }
        if ((fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId = InfoBookParser.getNodeResourceLocation(node))) == null) {
            throw new InvalidAppendixException("Invalid fluid " + String.valueOf(fluidId));
        }
        return new FluidStack(fluid, amount);
    }

    public static List<FluidStack> createFluidStacksFromIngredient(Element ingredientNode) throws InvalidAppendixException {
        NonNullList stacks = NonNullList.m_122779_();
        NodeList nodes = ingredientNode.getElementsByTagName("fluid");
        for (int i = 0; i < nodes.getLength(); ++i) {
            stacks.add(InfoBookParser.createFluidStack((Element)nodes.item(i)));
        }
        return stacks;
    }

    @Nullable
    public static FluidStack createFluidStackFromIngredient(Element ingredientNode) throws InvalidAppendixException {
        List<FluidStack> stacks = InfoBookParser.createFluidStacksFromIngredient(ingredientNode);
        if (stacks.size() != 1) {
            throw new InvalidAppendixException("At least one fluid node is required");
        }
        return stacks.get(0);
    }

    @Nullable
    public static FluidStack createOptionalFluidStackFromIngredient(Element ingredientNode) {
        return InfoBookParser.invalidAppendixExceptionThrowableOr(() -> InfoBookParser.createFluidStackFromIngredient(ingredientNode), null);
    }

    public static List<FluidStack> createOptionalFluidStacksFromIngredient(Element ingredientNode) {
        NonNullList stacks = NonNullList.m_122779_();
        NodeList nodes = ingredientNode.getElementsByTagName("fluid");
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                stacks.add(InfoBookParser.createFluidStackFromIngredient((Element)nodes.item(i)));
                continue;
            }
            catch (InvalidAppendixException invalidAppendixException) {
                // empty catch block
            }
        }
        return stacks;
    }

    public static <R> R invalidAppendixExceptionThrowableOr(InvalidAppendixException.IThrower<R> thrower, R fallback) {
        try {
            return thrower.run();
        }
        catch (InvalidAppendixException e) {
            return fallback;
        }
    }

    public static InfoSection initializeInfoBook(ModBase<?> mod, IInfoBook infoBook, String path, @Nullable InfoSection parent) {
        try {
            InfoSectionTagIndex tagIndex;
            InputStream is = mod.getClass().getResourceAsStream(path);
            StreamSource stream = new StreamSource(is);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream.getInputStream());
            InfoSection root = InfoBookParser.buildSection(infoBook, parent, 0, doc.getDocumentElement(), mod);
            if (parent == null) {
                tagIndex = new InfoSectionTagIndex(infoBook, root, mod);
                root.registerSection(tagIndex);
                infoBook.putIndex(tagIndex);
            } else {
                tagIndex = infoBook.getTagIndex();
            }
            tagIndex.addSoftLinks(root);
            return root;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            throw new InfoBookException("Info Book XML is invalid.");
        }
    }

    protected static InfoSection buildSection(IInfoBook infoBook, InfoSection parent, int childIndex, Element sectionElement, ModBase<?> modSection) {
        ModBase modBook = infoBook.getMod();
        NodeList sections = sectionElement.getElementsByTagName("section");
        NodeList tags = sectionElement.getElementsByTagName("tag");
        NodeList paragraphs = sectionElement.getElementsByTagName("paragraph");
        NodeList appendixes = sectionElement.getElementsByTagName("appendix");
        NodeList appendixLists = sectionElement.getElementsByTagName("appendix_list");
        ArrayList paragraphList = Lists.newArrayListWithCapacity((int)paragraphs.getLength());
        ArrayList appendixList = Lists.newArrayListWithCapacity((int)appendixes.getLength());
        ArrayList tagList = Lists.newArrayListWithCapacity((int)tags.getLength());
        String sectionName = sectionElement.getAttribute("name");
        InfoSection section = InfoBookParser.createSection(infoBook, parent, childIndex, sectionElement.getAttribute("type"), sectionName, paragraphList, appendixList, tagList, modSection);
        infoBook.addSection(sectionName, section);
        if (sections.getLength() > 0) {
            int subChildIndex = 0;
            for (int i = 0; i < sections.getLength(); ++i) {
                InfoSection subsubsection;
                Element subsection = (Element)sections.item(i);
                if (subsection.getParentNode() != sectionElement || (subsubsection = InfoBookParser.buildSection(infoBook, section, subChildIndex, subsection, modSection)) == null) continue;
                section.registerSection(subsubsection);
                ++subChildIndex;
            }
        } else {
            int j;
            for (j = 0; j < tags.getLength(); ++j) {
                ISectionConditionHandler conditionHandler;
                Element tag = (Element)tags.item(j);
                String tagString = tag.getTextContent();
                String type = "config";
                if (tag.hasAttribute("type")) {
                    type = tag.getAttribute("type");
                }
                ModBase modRecipe = modBook;
                if (tagString.contains(":")) {
                    String[] split = tagString.split(":");
                    modRecipe = ModBase.get(split[0]);
                    tagString = split[1];
                }
                if (!(conditionHandler = Objects.requireNonNull(RECIPE_CONDITION_HANDLERS.get(type), "Could not find a recipe condition handler by name " + type)).isSatisfied(modRecipe, tagString)) {
                    infoBook.getMod().log(Level.INFO, "Skipped section " + sectionName + " due to unsatisfied " + type + " condition.");
                    return null;
                }
                if (!(conditionHandler instanceof ConfigSectionConditionHandler)) continue;
                tagList.add(tag.getTextContent());
            }
            for (j = 0; j < paragraphs.getLength(); ++j) {
                Element paragraph = (Element)paragraphs.item(j);
                paragraphList.add(paragraph.getTextContent());
            }
            for (j = 0; j < appendixes.getLength(); ++j) {
                try {
                    Element appendix = (Element)appendixes.item(j);
                    SectionAppendix sectionAppendix = InfoBookParser.createAppendix(infoBook, appendix.getAttribute("type"), appendix);
                    if (sectionAppendix == null) continue;
                    appendixList.add(sectionAppendix);
                    continue;
                }
                catch (InvalidAppendixException e) {
                    e.setState(infoBook, parent);
                    infoBook.getMod().log(Level.WARN, e.toString());
                }
            }
            for (j = 0; j < appendixLists.getLength(); ++j) {
                Element appendixListNode = (Element)appendixLists.item(j);
                String factoryType = appendixListNode.getAttribute("factory");
                if (Strings.isEmpty((CharSequence)factoryType)) {
                    factoryType = "default";
                }
                if (!Strings.isNotEmpty((CharSequence)factoryType)) continue;
                try {
                    appendixList.addAll(InfoBookParser.createAppendixes(infoBook, factoryType, appendixListNode));
                    continue;
                }
                catch (InvalidAppendixException e) {
                    e.setState(infoBook, parent);
                    infoBook.getMod().log(Level.WARN, e.toString());
                }
            }
        }
        return section;
    }

    protected static InfoSection createSection(IInfoBook infoBook, InfoSection parent, int childIndex, String type, String translationKey, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList, ModBase<?> mod) {
        IInfoSectionFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = SECTION_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No section of type '" + type + "' was found.");
        }
        return factory.create(infoBook, parent, childIndex, translationKey, paragraphs, appendixes, tagList, mod);
    }

    protected static SectionAppendix createAppendix(IInfoBook infoBook, String type, Element node) throws InvalidAppendixException {
        IAppendixFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = APPENDIX_FACTORIES.get(type)) == null) {
            if (IGNORED_APPENDIX_FACTORIES.contains(type)) {
                throw new InvalidAppendixException("Ignore appendix of type '" + type + "'.");
            }
            throw new InfoBookException("No appendix of type '" + type + "' was found.");
        }
        return factory.create(infoBook, node);
    }

    protected static SectionAppendix createAppendix(IInfoBook infoBook, String type, Recipe<?> recipe) throws InvalidAppendixException {
        IAppendixItemFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = APPENDIX_RECIPELIST_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No appendix list of type '" + type + "' was found.");
        }
        return factory.create(infoBook, recipe);
    }

    protected static List<SectionAppendix> createAppendixes(IInfoBook infoBook, String factory, Element node) throws InvalidAppendixException {
        IAppendixListFactory factoryInstance;
        if (factory == null) {
            factory = "";
        }
        if ((factoryInstance = APPENDIX_LIST_FACTORIES.get(factory)) == null) {
            throw new InfoBookException("No appendix list of factory '" + factory + "' was found.");
        }
        return factoryInstance.create(infoBook, node);
    }

    protected static IReward createReward(IInfoBook infoBook, String type, Element node) throws InvalidAppendixException {
        IRewardFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = REWARD_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No reward factory of type '" + type + "' was found.");
        }
        return factory.create(infoBook, node);
    }

    static {
        InfoBookParser.registerSectionFactory("", new IInfoSectionFactory(){

            @Override
            public InfoSection create(IInfoBook infoBook, InfoSection parent, int childIndex, String translationKey, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
                return this.create(infoBook, parent, childIndex, translationKey, paragraphs, appendixes, tagList, null);
            }

            @Override
            public InfoSection create(IInfoBook infoBook, InfoSection parent, int childIndex, String translationKey, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList, ModBase<?> mod) {
                return new InfoSection(infoBook, parent, childIndex, translationKey, paragraphs, appendixes, tagList, mod);
            }
        });
        InfoBookParser.registerAppendixFactory("image", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                return new ImageAppendix(infoBook, InfoBookParser.getNodeResourceLocation(node), Integer.parseInt(node.getAttribute("width")), Integer.parseInt(node.getAttribute("height")));
            }
        });
        InfoBookParser.registerAppendixFactory("textfield", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                return new TextFieldAppendix(infoBook, node.getTextContent(), Double.parseDouble(node.getAttribute("scale")));
            }
        });
        InfoBookParser.registerAppendixRecipeFactories(RecipeType.f_44107_, CraftingRecipeAppendix::new);
        InfoBookParser.registerAppendixRecipeFactories(RecipeType.f_44108_, FurnaceRecipeAppendix::new);
        InfoBookParser.registerAppendixFactory("advancement_rewards", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                if (infoBook.getMod().getReferenceValue(ModBase.REFKEY_INFOBOOK_REWARDS).booleanValue()) {
                    ArrayList advancements = Lists.newArrayList();
                    ArrayList rewards = Lists.newArrayList();
                    String achievementRewardsId = node.getAttribute("id");
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        int j;
                        if (!(children.item(i) instanceof Element)) continue;
                        Element child = (Element)children.item(i);
                        NodeList subChildren = child.getChildNodes();
                        if (child.getNodeName().equals("advancements")) {
                            for (j = 0; j < subChildren.getLength(); ++j) {
                                Element advancementNode;
                                String advancementId;
                                if (!(subChildren.item(j) instanceof Element) || (advancementId = (advancementNode = (Element)subChildren.item(j)).getAttribute("id")).isEmpty()) continue;
                                advancements.add(new ResourceLocation(advancementId));
                            }
                            continue;
                        }
                        if (!child.getNodeName().equals("rewards")) continue;
                        for (j = 0; j < subChildren.getLength(); ++j) {
                            if (!(subChildren.item(j) instanceof Element)) continue;
                            Element rewardNode = (Element)subChildren.item(j);
                            String rewardType = rewardNode.getAttribute("type");
                            rewards.add(InfoBookParser.createReward(infoBook, rewardType, rewardNode));
                        }
                    }
                    if (achievementRewardsId == null || achievementRewardsId.isEmpty()) {
                        throw new InvalidAppendixException("Every advancement rewards tag must have a unique id attribute");
                    }
                    AdvancementRewards advancementRewards = new AdvancementRewards(achievementRewardsId, advancements, rewards);
                    return new AdvancementRewardsAppendix(infoBook, advancementRewards);
                }
                return null;
            }
        });
        InfoBookParser.registerAppendixFactory("keybinding", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                return new KeyBindingAppendix(infoBook, node.getTextContent());
            }
        });
        InfoBookParser.registerAppendixListFactory("default", new IAppendixListFactory(){

            @Override
            public List<SectionAppendix> create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                ArrayList appendixList = Lists.newArrayList();
                String type = node.getAttribute("type");
                RecipeType recipeType = (RecipeType)ForgeRegistries.RECIPE_TYPES.getValue(new ResourceLocation(type));
                if (recipeType == null) {
                    throw new InvalidAppendixException("Could not find a recipe type: " + type);
                }
                Map recipes = CraftingHelpers.getRecipeManager().m_44054_(recipeType);
                String idRegexString = node.getTextContent().trim();
                for (Recipe recipe : recipes.values()) {
                    try {
                        if (!idRegexString.isEmpty() && !recipe.m_6423_().toString().matches(idRegexString)) continue;
                        appendixList.add(InfoBookParser.createAppendix(infoBook, type, recipe));
                    }
                    catch (InvalidAppendixException e) {
                        e.setState(infoBook, null);
                        infoBook.getMod().log(Level.WARN, e.toString());
                    }
                }
                return appendixList;
            }
        });
        InfoBookParser.registerAppendixRewardFactory("item", new IRewardFactory(){

            @Override
            public IReward create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                ItemStack itemStack = InfoBookParser.createStack(node);
                return new RewardItem(itemStack);
            }
        });
        RECIPE_CONDITION_HANDLERS.put("config", new ConfigSectionConditionHandler());
        RECIPE_CONDITION_HANDLERS.put("mod", new ModSectionConditionHandler());
        RECIPE_CONDITION_HANDLERS.put("itemtag", new TagSectionConditionHandler(ForgeRegistries.ITEMS.tags(), Registry.f_122904_));
        RECIPE_CONDITION_HANDLERS.put("blocktag", new TagSectionConditionHandler(ForgeRegistries.BLOCKS.tags(), Registry.f_122901_));
        RECIPE_CONDITION_HANDLERS.put("fluid", new FluidSectionConditionHandler());
        RECIPE_CONDITION_HANDLERS.put("item", new ItemSectionConditionHandler());
    }

    public static interface IAppendixItemFactory<C extends Container, R extends Recipe<C>> {
        public SectionAppendix create(IInfoBook var1, R var2) throws InvalidAppendixException;
    }

    public static interface IAppendixFactory {
        public SectionAppendix create(IInfoBook var1, Element var2) throws InvalidAppendixException;
    }

    public static class InvalidAppendixException
    extends Exception {
        private IInfoBook infoBook;
        private InfoSection section;

        public InvalidAppendixException(String message) {
            super(message);
        }

        public void setState(IInfoBook infoBook, @Nullable InfoSection section) {
            this.infoBook = infoBook;
            this.section = section;
        }

        @Override
        public String toString() {
            return String.format("Invalid appendix %s from mod %s in an infobook: %s", this.section != null ? this.section.getTranslationKey() : "<root>", this.infoBook.getMod(), this.getLocalizedMessage());
        }

        public static interface IThrower<R> {
            public R run() throws InvalidAppendixException;
        }
    }

    public static class InfoBookException
    extends RuntimeException {
        public InfoBookException(String message) {
            super(message);
        }
    }

    public static interface IInfoSectionFactory {
        @Deprecated
        public InfoSection create(IInfoBook var1, InfoSection var2, int var3, String var4, ArrayList<String> var5, List<SectionAppendix> var6, ArrayList<String> var7);

        default public InfoSection create(IInfoBook infoBook, InfoSection parent, int childIndex, String translationKey, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList, ModBase<?> mod) {
            return this.create(infoBook, parent, childIndex, translationKey, paragraphs, appendixes, tagList);
        }
    }

    public static interface IAppendixListFactory {
        public List<SectionAppendix> create(IInfoBook var1, Element var2) throws InvalidAppendixException;
    }
}

