/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.cyclops.cyclopscore.recipe.type.RecipeCraftingShapelessCustomOutput;

public class RecipeSerializerCraftingShapelessCustomOutput
implements RecipeSerializer<RecipeCraftingShapelessCustomOutput> {
    private final Supplier<ItemStack> outputProvider;
    @Nullable
    private final IOutputTransformer outputTransformer;

    public RecipeSerializerCraftingShapelessCustomOutput(Supplier<ItemStack> outputProvider, @Nullable IOutputTransformer outputTransformer) {
        this.outputProvider = outputProvider;
        this.outputTransformer = outputTransformer;
    }

    public RecipeSerializerCraftingShapelessCustomOutput(Supplier<ItemStack> outputProvider) {
        this(outputProvider, null);
    }

    @Nullable
    public IOutputTransformer getOutputTransformer() {
        return this.outputTransformer;
    }

    public RecipeCraftingShapelessCustomOutput fromJson(ResourceLocation recipeId, JsonObject json) {
        String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> nonnulllist = RecipeSerializerCraftingShapelessCustomOutput.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        ItemStack itemstack = this.outputProvider.get();
        return new RecipeCraftingShapelessCustomOutput(this, recipeId, s, itemstack, nonnulllist);
    }

    private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < p_44276_.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)p_44276_.get(i));
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public RecipeCraftingShapelessCustomOutput fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String s = buffer.m_130277_();
        int i = buffer.m_130242_();
        NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
        for (int j = 0; j < nonnulllist.size(); ++j) {
            nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        ItemStack itemstack = buffer.m_130267_();
        return new RecipeCraftingShapelessCustomOutput(this, recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeCraftingShapelessCustomOutput recipe) {
        buffer.m_130070_(recipe.m_6076_());
        buffer.m_130130_(recipe.m_7527_().size());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130055_(recipe.m_8043_());
    }

    public static interface IOutputTransformer {
        public ItemStack transform(CraftingContainer var1, ItemStack var2);
    }
}

