/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockEntityTomb;
import com.lothrazar.simpletomb.block.ModelTomb;
import com.lothrazar.simpletomb.data.DeathHelper;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.item.GraveKeyItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTomb
extends BaseEntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.m_61631_((String)"model_texture", (int)0, (int)1);
    public static final BooleanProperty IS_ENGRAVED = BooleanProperty.m_61465_((String)"is_engraved");
    private static final VoxelShape GROUND = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected final String name;
    protected final ModelTomb graveModel;

    public BlockTomb(BlockBehaviour.Properties properties, ModelTomb graveModel) {
        super(properties.m_60955_().m_60913_(-1.0f, 3600000.0f));
        this.graveModel = graveModel;
        this.name = graveModel.m_7912_();
    }

    public RenderShape m_7514_(BlockState bs) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return GROUND;
    }

    public ModelTomb getGraveType() {
        return this.graveModel;
    }

    public String m_7705_() {
        return "simpletomb.grave." + this.name;
    }

    public boolean m_6903_(Explosion explosionIn) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public static BlockEntityTomb getBlockEntity(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof BlockEntityTomb ? (BlockEntityTomb)blockEntity : null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityTomb(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockTomb.m_152132_(type, (BlockEntityType)((BlockEntityType)TombRegistry.TOMBSTONE_BLOCK_ENTITY.get()), (BlockEntityTicker)(level.f_46443_ ? BlockEntityTomb::clientTick : BlockEntityTomb::serverTick));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{IS_ENGRAVED}).m_61104_(new Property[]{MODEL_TEXTURE});
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_ && entity.m_6144_() && entity.m_6084_() && EntityHelper.isValidPlayer(entity)) {
            BlockTomb.activatePlayerGrave(level, pos, state, (Player)((ServerPlayer)entity));
        }
    }

    public static void activatePlayerGrave(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntityTomb tile = BlockTomb.getBlockEntity(level, pos);
        if (tile != null && player.m_6084_()) {
            if (tile.onlyOwnersCanAccess() && !tile.isOwner(player)) {
                MessageType.MESSAGE_OPEN_GRAVE_NEED_OWNER.sendSpecialMessage(player, new Object[0]);
                return;
            }
            tile.giveInventory(player);
            DeathHelper.INSTANCE.deleteLastGrave(player);
            ((GraveKeyItem)((Object)TombRegistry.GRAVE_KEY.get())).removeKeyForGraveInInventory(player, new LocationBlockPos(pos, level));
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof BlockEntityTomb) {
                BlockEntityTomb blockEntityTomb = (BlockEntityTomb)blockentity;
                blockEntityTomb.dropInventory(level, pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

