/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.particle.CustomParticle;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleCasting
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("simpletomb", "textures/particle/casting.png");
    private final LivingEntity caster;
    private final Predicate<LivingEntity> predic;
    private final double radius = 1.1;
    private double angle;
    private static final double ROT_INCR = 0.15707963267948966;
    private final float colorR;
    private final float colorG;
    private final float colorB;
    private boolean goUp;

    public ParticleCasting(ClientLevel world, LivingEntity caster, Predicate<LivingEntity> predic, double addY, double angle) {
        super(world, caster.m_20185_(), caster.m_20186_() + addY, caster.m_20189_());
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.m_107271_(1.0f);
        this.goUp = addY < 1.0;
        this.caster = caster;
        this.predic = predic;
        this.f_107663_ = world.f_46441_.m_188501_() * 0.1f + 0.15f;
        this.angle = angle + (double)WorldHelper.getRandom(world.f_46441_, -0.25, 0.25);
        this.f_107231_ = world.f_46441_.m_188501_() * ((float)Math.PI * 2);
        float[] color = WorldHelper.getRGBColor3F(14937088);
        this.colorR = color[0];
        this.colorG = color[1];
        this.colorB = color[2];
        this.f_107219_ = false;
        this.updatePosition();
    }

    private void updatePosition() {
        this.angle += (double)0.01f;
        this.f_107209_ = this.f_107212_ = this.caster.m_20185_() + this.radius * Math.cos(Math.PI * 2 * this.angle);
        this.f_107210_ = this.f_107213_ += this.goUp ? 0.02 : -0.02;
        this.f_107211_ = this.f_107214_ = this.caster.m_20189_() + this.radius * Math.sin(Math.PI * 2 * this.angle);
        this.m_107253_(this.clampColor(this.colorR + WorldHelper.getRandom(this.f_107208_.f_46441_, -20.0, 20.0) / 255.0f), this.clampColor(this.colorG - WorldHelper.getRandom(this.f_107208_.f_46441_, -20.0, 20.0) / 255.0f), this.clampColor(this.colorB + WorldHelper.getRandom(this.f_107208_.f_46441_, -20.0, 20.0) / 255.0f));
        this.f_107204_ = this.f_107231_;
        this.f_107231_ = (float)((double)this.f_107231_ + 0.15707963267948966);
    }

    private float clampColor(float color) {
        return Mth.m_14036_((float)color, (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        if (this.f_107213_ > this.caster.m_20186_() + 2.0 || this.f_107213_ < this.caster.m_20186_()) {
            boolean bl = this.goUp = !this.goUp;
        }
        if (this.predic.test(this.caster)) {
            this.m_107274_();
        }
        this.updatePosition();
        ++this.f_107224_;
    }

    protected int m_6355_(float partialTick) {
        int skylight = 5;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

