/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleGraveSoul
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final double radius;
    private final double centerX;
    private final double centerZ;

    private ParticleGraveSoul(SpriteSet spriteSet, ClientLevel world, double x, double y, double z, double radius) {
        super(world, x, y + 0.85, z);
        this.f_107225_ = 100;
        this.f_107663_ = 0.03f;
        this.centerX = x + 0.5;
        this.centerZ = z + 0.5;
        this.radius = radius;
        this.updatePosition();
        this.m_107271_(0.7f);
        this.m_107253_(0.31764707f, 0.09803922f, 0.54509807f);
        this.f_107219_ = false;
        this.spriteSet = spriteSet;
        this.m_108339_(this.spriteSet);
    }

    private void updatePosition() {
        double ratio = (double)this.f_107224_ / (double)this.f_107225_;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107209_ = this.f_107212_ = this.centerX + this.radius * Math.cos(Math.PI * 2 * ratio);
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_ = this.centerZ + this.radius * Math.sin(Math.PI * 2 * ratio);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.m_107276_()) {
            this.m_108339_(this.spriteSet);
            this.updatePosition();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ParticleGraveSoul(this.spriteSet, world, x, y, z, 0.3);
        }
    }
}

