/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.launch.ILaunchPropertyManager;
import mod.chiselsandbits.api.plugin.IPluginDiscoverer;
import mod.chiselsandbits.api.plugin.PluginData;
import mod.chiselsandbits.api.util.ClassUtils;
import mod.chiselsandbits.api.util.GroupingUtils;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

public final class ForgePluginDiscoverer
implements IPluginDiscoverer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ForgePluginDiscoverer INSTANCE = new ForgePluginDiscoverer();

    public static ForgePluginDiscoverer getInstance() {
        return INSTANCE;
    }

    private ForgePluginDiscoverer() {
    }

    @Override
    public <A, I extends Annotation, T> Collection<PluginData<T>> loadPlugins(Class<A> annotationType, Class<I> instanceAnnotationType, Class<T> pluginSpecificationType, Function<T, String> idExtractor) {
        Type pluginType = Type.getType(annotationType);
        ModList modList = ModList.get();
        ArrayList<PluginData<T>> plugins = new ArrayList<PluginData<T>>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                PluginData<T> plugin;
                Boolean isExperimental;
                ArrayList requiredMods;
                if (!pluginType.equals((Object)data.annotationType()) || (requiredMods = (ArrayList)data.annotationData().get("requiredMods")) != null && requiredMods.size() > 0 && requiredMods.stream().anyMatch(modId -> !ModList.get().isLoaded(modId)) || (isExperimental = (Boolean)data.annotationData().get("isExperimental")) != null && isExperimental.booleanValue() && !Boolean.parseBoolean(ILaunchPropertyManager.getInstance().get("plugins.experimental", "false")) || (plugin = ForgePluginDiscoverer.createPluginFrom(data.memberName(), pluginSpecificationType, instanceAnnotationType, idExtractor, isExperimental != null && isExperimental != false)) == null) continue;
                plugins.add(plugin);
                LOGGER.info("Found and loaded ChiselsAndBits plugin: {}", (Object)idExtractor.apply(plugin.plugin()));
            }
        }
        Collection<Collection<PluginData>> groupedByIds = GroupingUtils.groupByUsingSet(plugins, tPluginData -> (String)idExtractor.apply(tPluginData.plugin()));
        Collection idsWithDuplicates = groupedByIds.stream().filter(p -> p.size() > 1).map(p -> (PluginData)p.iterator().next()).map(d -> (String)idExtractor.apply(d.plugin())).collect(Collectors.toSet());
        if (idsWithDuplicates.size() > 0) {
            throw new RuntimeException(String.format("Can not load C&B there are multiple instances of the plugins: [%s]", String.join((CharSequence)", ", idsWithDuplicates)));
        }
        return ImmutableSet.copyOf(plugins);
    }

    @Nullable
    private static <T, I extends Annotation> PluginData<T> createPluginFrom(String className, Class<T> pluginSpecificationType, Class<I> instanceAnnotationType, Function<T, String> idExtractor, boolean isExperimental) {
        T plugin = ClassUtils.createOrGetInstance(className, pluginSpecificationType, instanceAnnotationType, idExtractor);
        if (plugin == null) {
            return null;
        }
        return new PluginData<T>(plugin, isExperimental);
    }
}

