/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mutil.data;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import se.mickelus.mutil.network.AbstractPacket;

@ParametersAreNonnullByDefault
public abstract class AbstractUpdateDataPacket
extends AbstractPacket {
    protected String directory;
    protected Map<ResourceLocation, String> data;

    public AbstractUpdateDataPacket() {
    }

    public AbstractUpdateDataPacket(String directory, Map<ResourceLocation, JsonElement> data) {
        this.directory = directory;
        this.data = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).toString()));
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.directory);
        buffer.writeInt(this.data.size());
        this.data.forEach((resourceLocation, data) -> {
            buffer.m_130085_(resourceLocation);
            buffer.m_130070_(data);
        });
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.directory = buffer.m_130277_();
        int count = buffer.readInt();
        this.data = new HashMap<ResourceLocation, String>();
        for (int i = 0; i < count; ++i) {
            this.data.put(buffer.m_130281_(), buffer.m_130277_());
        }
    }

    @Override
    public abstract void handle(Player var1);
}

