/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyInt;
import brentmaas.buildguide.common.property.PropertyRunnable;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeSet;

public class ShapeLine
extends Shape {
    private PropertyInt propertyDx = new PropertyInt(3, new AbstractScreenHandler.Translatable("property.buildguide.delta", "X"), () -> this.update());
    private PropertyInt propertyDy = new PropertyInt(0, new AbstractScreenHandler.Translatable("property.buildguide.delta", "Y"), () -> this.update());
    private PropertyInt propertyDz = new PropertyInt(0, new AbstractScreenHandler.Translatable("property.buildguide.delta", "Z"), () -> this.update());
    private PropertyRunnable propertySetEndpoint = new PropertyRunnable(() -> {
        ShapeSet.Origin pos = BuildGuide.shapeHandler.getPlayerPosition();
        this.propertyDx.setValue(pos.x - this.shapeSet.origin.x);
        this.propertyDy.setValue(pos.y - this.shapeSet.origin.y);
        this.propertyDz.setValue(pos.z - this.shapeSet.origin.z);
        this.update();
    }, new AbstractScreenHandler.Translatable("property.buildguide.setendpoint", new Object[0]));

    public ShapeLine() {
        this.properties.add(this.propertyDx);
        this.properties.add(this.propertyDy);
        this.properties.add(this.propertyDz);
        this.properties.add(this.propertySetEndpoint);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        int d = Math.max(Math.max(Math.abs((Integer)this.propertyDx.value), Math.abs((Integer)this.propertyDy.value)), Math.abs((Integer)this.propertyDz.value));
        double dx = (double)((Integer)this.propertyDx.value).intValue() / (double)d;
        double dy = (double)((Integer)this.propertyDy.value).intValue() / (double)d;
        double dz = (double)((Integer)this.propertyDz.value).intValue() / (double)d;
        for (int i = 0; i <= d; ++i) {
            this.addShapeCube(buffer, (int)(dx * (double)i + 0.5 * (double)Math.signum(((Integer)this.propertyDx.value).intValue())), (int)(dy * (double)i + 0.5 * (double)Math.signum(((Integer)this.propertyDy.value).intValue())), (int)(dz * (double)i + 0.5 * (double)Math.signum(((Integer)this.propertyDz.value).intValue())));
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.line";
    }
}

