/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.progress;

import com.google.common.collect.Lists;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.container.addon.IntArrayReferenceHolderAddon;
import com.hrznstudio.titanium.container.referenceholder.ProgressBarReferenceHolder;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public class ProgressBarComponent<T extends IComponentHarness>
implements INBTSerializable<CompoundTag>,
IScreenAddonProvider,
IContainerAddonProvider {
    private int posX;
    private int posY;
    private int progress;
    private int maxProgress;
    private int progressIncrease;
    private Predicate<T> canIncrease;
    private Predicate<T> canReset;
    private int tickingTime;
    private Runnable onFinishWork;
    private Runnable onTickWork;
    private Runnable onStart;
    private T componentHarness;
    private BarDirection barDirection;
    private DyeColor color;
    private boolean increaseType;

    public ProgressBarComponent(int posX, int posY, int maxProgress) {
        this.posX = posX;
        this.posY = posY;
        this.progress = 0;
        this.maxProgress = maxProgress;
        this.progressIncrease = 1;
        this.canIncrease = tileEntity -> false;
        this.canReset = tileEntity -> true;
        this.tickingTime = 1;
        this.onFinishWork = () -> {};
        this.onTickWork = () -> {};
        this.onStart = () -> {};
        this.barDirection = BarDirection.VERTICAL_UP;
        this.color = DyeColor.WHITE;
        this.increaseType = true;
    }

    public ProgressBarComponent(int posX, int posY, int progress, int maxProgress) {
        this(posX, posY, maxProgress);
        this.progress = progress;
    }

    public ProgressBarComponent<T> setOnFinishWork(Runnable runnable) {
        this.onFinishWork = runnable;
        return this;
    }

    public ProgressBarComponent<T> setOnTickWork(Runnable runnable) {
        this.onTickWork = runnable;
        return this;
    }

    public ProgressBarComponent<T> setOnStart(Runnable runnable) {
        this.onStart = runnable;
        return this;
    }

    public ProgressBarComponent<T> setComponentHarness(T componentHarness) {
        this.componentHarness = componentHarness;
        return this;
    }

    public T getComponentHarness() {
        return this.componentHarness;
    }

    public Predicate<T> getCanReset() {
        return this.canReset;
    }

    public ProgressBarComponent<T> setCanReset(Predicate<T> canReset) {
        this.canReset = canReset;
        return this;
    }

    public boolean getIncreaseType() {
        return this.increaseType;
    }

    public ProgressBarComponent<T> setIncreaseType(boolean increaseType) {
        this.increaseType = increaseType;
        return this;
    }

    public void tickBar() {
        if (this.componentHarness != null && this.componentHarness.getComponentWorld().m_46467_() % (long)this.tickingTime == 0L) {
            if (this.increaseType && this.progress < this.maxProgress) {
                this.setProgress(this.progress + this.progressIncrease);
                this.onTickWork.run();
            }
            if (!this.increaseType && this.progress > 0) {
                this.setProgress(this.progress - this.progressIncrease);
                this.onTickWork.run();
            }
        }
        if (this.increaseType && this.progress >= this.maxProgress && this.canReset.test(this.componentHarness)) {
            this.setProgress(0);
            this.onFinishWork.run();
        }
        if (!this.increaseType && this.progress <= 0 && this.canReset.test(this.componentHarness)) {
            this.setProgress(this.maxProgress);
            this.onFinishWork.run();
        }
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public Predicate<T> getCanIncrease() {
        return this.canIncrease;
    }

    public ProgressBarComponent<T> setCanIncrease(Predicate<T> canIncrease) {
        this.canIncrease = canIncrease;
        return this;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (this.componentHarness != null) {
            this.componentHarness.markComponentForUpdate(true);
        }
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public ProgressBarComponent<T> setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
        return this;
    }

    public int getTickingTime() {
        return this.tickingTime;
    }

    public ProgressBarComponent<T> setTickingTime(int tickingTime) {
        this.tickingTime = tickingTime;
        return this;
    }

    public int getProgressIncrease() {
        return this.progressIncrease;
    }

    public ProgressBarComponent<T> setProgressIncrease(int progressIncrease) {
        this.progressIncrease = progressIncrease;
        return this;
    }

    public BarDirection getBarDirection() {
        return this.barDirection;
    }

    public ProgressBarComponent<T> setBarDirection(BarDirection direction) {
        this.barDirection = direction;
        return this;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public ProgressBarComponent<T> setColor(DyeColor color) {
        this.color = color;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return Collections.singletonList(() -> new ProgressBarScreenAddon(this.posX, this.posY, this));
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("Tick", this.progress);
        compound.m_128405_("MaxProgress", this.maxProgress);
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.progress = nbt.m_128451_("Tick");
        this.maxProgress = nbt.m_128451_("MaxProgress");
    }

    public void onStart() {
        this.onStart.run();
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Lists.newArrayList((Object[])new IFactory[]{() -> new IntArrayReferenceHolderAddon(new ProgressBarReferenceHolder(this))});
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BarDirection {
        VERTICAL_UP{

            @Override
            public <T extends IComponentHarness> void render(PoseStack stack, Screen screen, int guiX, int guiY, IAssetProvider provider, ProgressBarScreenAddon<T> addon) {
                IAsset assetBorder = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BORDER_VERTICAL);
                Point offset = assetBorder.getOffset();
                Rectangle area = assetBorder.getArea();
                RenderSystem.m_157456_((int)0, (ResourceLocation)assetBorder.getResourceLocation());
                screen.m_93228_(stack, guiX + addon.getPosX() + offset.x, guiY + addon.getPosY() + offset.y, area.x, area.y, area.width, area.height);
                RenderSystem.m_157429_((float)addon.getProgressBar().getColor().m_41068_()[0], (float)addon.getProgressBar().getColor().m_41068_()[1], (float)addon.getProgressBar().getColor().m_41068_()[2], (float)1.0f);
                IAsset assetBar = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_VERTICAL);
                offset = assetBar.getOffset();
                area = assetBar.getArea();
                RenderSystem.m_157456_((int)0, (ResourceLocation)assetBar.getResourceLocation());
                screen.m_93228_(stack, guiX + addon.getPosX() + offset.x, guiY + addon.getPosY() + offset.y, area.x, area.y, area.width, area.height);
                IAsset asset = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_VERTICAL);
                offset = asset.getOffset();
                area = asset.getArea();
                RenderSystem.m_157456_((int)0, (ResourceLocation)asset.getResourceLocation());
                int progress = addon.getProgressBar().getProgress();
                int maxProgress = addon.getProgressBar().getMaxProgress();
                int progressOffset = progress * area.height / Math.max(maxProgress, 1);
                screen.m_93228_(stack, addon.getPosX() + offset.x + guiX, addon.getPosY() + offset.y + area.height - progressOffset + guiY, area.x, area.y + (area.height - progressOffset), area.width, progressOffset);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }

            @Override
            public int getXSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BORDER_VERTICAL).getArea().getWidth();
            }

            @Override
            public int getYSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BORDER_VERTICAL).getArea().getHeight();
            }
        }
        ,
        ARROW_RIGHT{

            @Override
            public <T extends IComponentHarness> void render(PoseStack stack, Screen screen, int guiX, int guiY, IAssetProvider provider, ProgressBarScreenAddon<T> addon) {
                AssetUtil.drawAsset(stack, screen, IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_HORIZONTAL), addon.getPosX() + guiX, addon.getPosY() + guiY);
                IAsset asset = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_ARROW_HORIZONTAL);
                Point offset = asset.getOffset();
                Rectangle area = asset.getArea();
                RenderSystem.m_157456_((int)0, (ResourceLocation)asset.getResourceLocation());
                int progress = addon.getProgressBar().getProgress();
                int maxProgress = addon.getProgressBar().getMaxProgress();
                int progressOffset = progress * area.width / Math.max(maxProgress, 1);
                RenderSystem.m_157429_((float)addon.getProgressBar().getColor().m_41068_()[0], (float)addon.getProgressBar().getColor().m_41068_()[1], (float)addon.getProgressBar().getColor().m_41068_()[2], (float)1.0f);
                screen.m_93228_(stack, addon.getPosX() + offset.x + guiX, addon.getPosY() + offset.y + guiY, area.x, area.y, progressOffset, area.height);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }

            @Override
            public int getXSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_HORIZONTAL).getArea().getWidth();
            }

            @Override
            public int getYSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_HORIZONTAL).getArea().getHeight();
            }
        }
        ,
        ARROW_DOWN{

            @Override
            public <T extends IComponentHarness> void render(PoseStack stack, Screen screen, int guiX, int guiY, IAssetProvider provider, ProgressBarScreenAddon<T> addon) {
                AssetUtil.drawAsset(stack, screen, IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_DOWN), addon.getPosX() + guiX, addon.getPosY() + guiY);
                IAsset asset = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_ARROW_DOWN);
                Point offset = asset.getOffset();
                Rectangle area = asset.getArea();
                RenderSystem.m_157456_((int)0, (ResourceLocation)asset.getResourceLocation());
                int progress = addon.getProgressBar().getProgress();
                int maxProgress = addon.getProgressBar().getMaxProgress();
                int progressOffset = progress * area.height / Math.max(maxProgress, 1);
                RenderSystem.m_157429_((float)addon.getProgressBar().getColor().m_41068_()[0], (float)addon.getProgressBar().getColor().m_41068_()[1], (float)addon.getProgressBar().getColor().m_41068_()[2], (float)1.0f);
                screen.m_93228_(stack, addon.getPosX() + offset.x + guiX, addon.getPosY() + offset.y + guiY, area.x, area.y, area.width, progressOffset);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }

            @Override
            public int getXSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_DOWN).getArea().getWidth();
            }

            @Override
            public int getYSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_DOWN).getArea().getHeight();
            }
        };


        @OnlyIn(value=Dist.CLIENT)
        public abstract <T extends IComponentHarness> void render(PoseStack var1, Screen var2, int var3, int var4, IAssetProvider var5, ProgressBarScreenAddon<T> var6);

        @OnlyIn(value=Dist.CLIENT)
        public abstract int getXSize(IAssetProvider var1);

        @OnlyIn(value=Dist.CLIENT)
        public abstract int getYSize(IAssetProvider var1);
    }
}

