/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.generator;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hrznstudio.titanium.recipe.generator.IJSONGenerator;
import com.hrznstudio.titanium.recipe.generator.IJsonFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TitaniumSerializableProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    private final Map<IJsonFile, IJSONGenerator> serializables;
    private final String modid;

    public TitaniumSerializableProvider(DataGenerator generatorIn, String modid) {
        this.generator = generatorIn;
        this.modid = modid;
        this.serializables = new HashMap<IJsonFile, IJSONGenerator>();
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        this.add(this.serializables);
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        this.serializables.forEach((iJsonFile, ijsonGenerator) -> {
            Path outputFile = path.resolve("data/" + this.modid + "/recipes/" + (String)(iJsonFile.getRecipeSubfolder() != null ? iJsonFile.getRecipeSubfolder() + "/" : "") + iJsonFile.getRecipeKey() + ".json");
            if (!set.add(outputFile)) {
                throw new IllegalStateException("Duplicate recipe " + iJsonFile.getRecipeKey());
            }
            this.saveRecipe(cache, ijsonGenerator.generate(), outputFile);
        });
    }

    protected void saveRecipe(CachedOutput cache, JsonObject recipeJson, Path output) {
        try {
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)recipeJson, (Path)output);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save recipe {}", (Object)output, (Object)ioexception);
        }
    }

    public abstract void add(Map<IJsonFile, IJSONGenerator> var1);

    public String m_6055_() {
        return "Titanium Serializable (" + this.modid + ")";
    }
}

