/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.emi.terminalstorage;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.RecipeFillButtonWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminalscompat.modcompat.common.RecipeTransferHelpers;
import org.cyclops.integratedterminalscompat.modcompat.common.RecipeTransferResult;
import org.cyclops.integratedterminalscompat.modcompat.emi.EmiIntegratedTerminalsConfig;
import org.cyclops.integratedterminalscompat.modcompat.emi.terminalstorage.RecipeInputSlotEmiIngredient;
import org.cyclops.integratedterminalscompat.modcompat.emi.terminalstorage.RecipeInputSlotEmiSlotWidget;

public class TerminalStorageEmiRecipeHandler<T extends ContainerTerminalStorageBase<?>>
implements EmiRecipeHandler<T> {
    private int previousChangeId;

    public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)screen.m_6262_();
        return RecipeTransferHelpers.getTabs(container).map(tabs -> new EmiPlayerInventory(((TerminalStorageTabIngredientComponentClient)tabs.getValue()).getRawUnfilteredIngredientsView(container.getSelectedChannel()).stream().map(EmiStack::of).collect(Collectors.toList()))).orElseGet(() -> new EmiPlayerInventory((List)Lists.newArrayList()));
    }

    public boolean supportsRecipe(EmiRecipe emiRecipe) {
        return emiRecipe instanceof EmiCraftingRecipe;
    }

    public boolean canCraft(EmiRecipe emiRecipe, EmiCraftContext<T> emiCraftContext) {
        return true;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)context.getScreen().m_6262_();
        RecipeTransferHelpers.getTabs(container).ifPresent(tabs -> {
            ArrayList recipeInputSlots = Lists.newArrayList();
            for (EmiIngredient input : recipe.getOutputs()) {
                recipeInputSlots.add(new RecipeInputSlotEmiIngredient(input, false));
            }
            for (EmiIngredient input : recipe.getInputs()) {
                recipeInputSlots.add(new RecipeInputSlotEmiIngredient(input, true));
            }
            RecipeTransferHelpers.transferRecipe(container, recipeInputSlots, (Player)Minecraft.m_91087_().f_91074_, (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabs.getLeft(), EmiIntegratedTerminalsConfig::getItemStackMatchCondition, false);
        });
        return true;
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<T> context) {
        ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)context.getScreen().m_6262_();
        return RecipeTransferHelpers.getTabs(container).map(tabs -> {
            ArrayList recipeInputSlots = Lists.newArrayList();
            for (EmiIngredient input : recipe.getInputs()) {
                recipeInputSlots.add(new RecipeInputSlotEmiIngredient(input, true));
            }
            return RecipeTransferHelpers.getMissingItems(Pair.of((Object)"tooltip", (Object)recipe), container, recipeInputSlots, (Player)Minecraft.m_91087_().f_91074_, (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabs.getLeft(), (TerminalStorageTabIngredientComponentClient)tabs.getRight(), EmiIntegratedTerminalsConfig::getItemStackMatchCondition, () -> this.previousChangeId, id -> {
                this.previousChangeId = id;
            }).map(result -> result.getMessage().stream().map(c -> ClientTooltipComponent.m_169948_((FormattedCharSequence)c.m_7532_())).collect(Collectors.toList())).orElseGet(List::of);
        }).orElseGet(List::of);
    }

    public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, PoseStack matrices) {
        ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)context.getScreen().m_6262_();
        RecipeTransferHelpers.getTabs(container).ifPresent(tabs -> {
            ArrayList recipeInputSlots = Lists.newArrayList();
            Wrapper fillButton = new Wrapper();
            for (Widget widget : widgets) {
                if (widget instanceof SlotWidget) {
                    SlotWidget slotWidget = (SlotWidget)widget;
                    recipeInputSlots.add(new RecipeInputSlotEmiSlotWidget(slotWidget));
                }
                if (!(widget instanceof RecipeFillButtonWidget)) continue;
                RecipeFillButtonWidget fillButtonWidget = (RecipeFillButtonWidget)widget;
                fillButton.set((Object)fillButtonWidget);
            }
            RecipeTransferHelpers.getMissingItems(Pair.of((Object)"render", (Object)recipe), container, recipeInputSlots, (Player)Minecraft.m_91087_().f_91074_, (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabs.getLeft(), (TerminalStorageTabIngredientComponentClient)tabs.getRight(), EmiIntegratedTerminalsConfig::getItemStackMatchCondition, () -> this.previousChangeId, id -> {
                this.previousChangeId = id;
            }).ifPresent(transferResult -> {
                Bounds bounds;
                for (RecipeInputSlotEmiSlotWidget slot : transferResult.getSlotsMissing()) {
                    bounds = slot.getSlotWidget().getBounds();
                    GuiComponent.m_93172_((PoseStack)matrices, (int)bounds.x(), (int)bounds.y(), (int)(bounds.x() + bounds.width()), (int)(bounds.y() + bounds.height()), (int)RecipeTransferResult.SLOT_COLOR_MISSING);
                }
                for (RecipeInputSlotEmiSlotWidget slot : transferResult.getSlotsCraftable()) {
                    bounds = slot.getSlotWidget().getBounds();
                    GuiComponent.m_93172_((PoseStack)matrices, (int)bounds.x(), (int)bounds.y(), (int)(bounds.x() + bounds.width()), (int)(bounds.y() + bounds.height()), (int)RecipeTransferResult.SLOT_COLOR_CRAFTABLE);
                }
                if (fillButton.get() != null) {
                    Bounds bounds2 = ((RecipeFillButtonWidget)fillButton.get()).getBounds();
                    GuiComponent.m_93172_((PoseStack)matrices, (int)bounds2.x(), (int)bounds2.y(), (int)(bounds2.x() + bounds2.width()), (int)(bounds2.y() + bounds2.height()), (int)transferResult.getButtonHighlightColor());
                }
            });
        });
    }
}

