/*
 * Decompiled with CFR 0.152.
 */
package tfar.unstabletools.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.unstabletools.datagen.BlockConversionBuilder;
import tfar.unstabletools.datagen.FinishedConversion;

public class BlockConversionProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator.PathProvider recipePathProvider;

    public BlockConversionProvider(DataGenerator generator) {
        this.recipePathProvider = generator.m_236036_(DataGenerator.Target.DATA_PACK, "recipes");
    }

    public void m_213708_(CachedOutput cache) {
        HashSet set = Sets.newHashSet();
        this.registerRecipes(conversion -> {
            if (!set.add(conversion.getID())) {
                throw new IllegalStateException("Duplicate recipe " + conversion.getID());
            }
            BlockConversionProvider.saveRecipe(cache, conversion.getRecipeJson(), this.recipePathProvider.m_236048_(conversion.getID()));
        });
    }

    private static void saveRecipe(CachedOutput cache, JsonObject json, Path path) {
        try {
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)path);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)ioexception);
        }
    }

    public String m_6055_() {
        return "Block Conversions";
    }

    protected void registerRecipes(Consumer<FinishedConversion> consumer) {
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50652_, Blocks.f_50069_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_49994_, Blocks.f_50652_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_49992_, Blocks.f_49994_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50450_, Blocks.f_49991_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50080_, Blocks.f_50450_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50058_, Blocks.f_49992_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50352_, Blocks.f_50129_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50324_, Blocks.f_50323_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50323_, Blocks.f_50322_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50590_, Blocks.f_50595_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50548_, Blocks.f_50553_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50580_, Blocks.f_50585_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50591_, Blocks.f_50596_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50549_, Blocks.f_50554_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50581_, Blocks.f_50586_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50592_, Blocks.f_50597_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50550_, Blocks.f_50555_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50582_, Blocks.f_50587_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50593_, Blocks.f_50598_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50551_, Blocks.f_50556_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50583_, Blocks.f_50588_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50589_, Blocks.f_50594_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50547_, Blocks.f_50552_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50579_, Blocks.f_50584_));
        for (DyeColor dyeColor : DyeColor.values()) {
            String name = dyeColor.name().toLowerCase(Locale.ROOT);
            Block from = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(name + "_stained_glass"));
            consumer.accept(BlockConversionBuilder.createBlockConversion(from, Blocks.f_50058_, new ResourceLocation("stained_glass_" + name)));
        }
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50093_, Blocks.f_50493_));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50493_, Blocks.f_50440_, new ResourceLocation("grass_block_2")));
        consumer.accept(BlockConversionBuilder.createBlockConversion(Blocks.f_50036_, Blocks.f_50746_));
    }
}

