/*
 * Decompiled with CFR 0.152.
 */
package tfar.unstabletools.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tfar.unstabletools.crafting.Config;
import tfar.unstabletools.item.IItemColored;

@Mod.EventBusSubscriber
public class ItemUnstableIngot
extends Item
implements IItemColored {
    public static final DamageSource DIVIDE_BY_DIAMOND = new DamageSource("divide_by_diamond").m_19380_();
    public static final DamageSource ESCAPE_DIVIDE_BY_DIAMOND = new DamageSource("escape_divide_by_diamond").m_19380_();

    public ItemUnstableIngot(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)"The product of dividing iron by diamond,").m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)Component.m_237113_((String)"handle with care").m_130940_(ChatFormatting.AQUA));
        }
        if (!stack.m_41782_()) {
            tooltip.add((Component)Component.m_237113_((String)"'Stable'"));
            return;
        }
        int timer = stack.m_41783_().m_128451_("timer");
        tooltip.add((Component)Component.m_237113_((String)("Time left: " + timer)));
    }

    @SubscribeEvent
    public static void playertick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        AbstractContainerMenu container = e.player.f_36096_;
        try {
            MenuType type = container.m_6772_();
            if (!((List)Config.ServerConfig.allowed_containers.get()).contains(Registry.f_122863_.m_7981_((Object)type).toString())) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        Level world = e.player.f_19853_;
        if (world.f_46443_) {
            return;
        }
        boolean explode = false;
        NonNullList inventorySlots = container.f_38839_;
        for (Slot slot : inventorySlots) {
            ItemStack stack = slot.m_7993_();
            if (!(stack.m_41720_() instanceof ItemUnstableIngot) || !stack.m_41782_() || slot instanceof ResultSlot) continue;
            int timer = stack.m_41783_().m_128451_("timer");
            if (timer <= 0) {
                slot.m_5852_(ItemStack.f_41583_);
                explode = true;
                continue;
            }
            stack.m_41783_().m_128405_("timer", --timer);
        }
        if (!explode) {
            return;
        }
        ItemUnstableIngot.boom(e.player);
    }

    @SubscribeEvent
    public static void onContainerClose(PlayerContainerEvent.Close e) {
        AbstractContainerMenu c = e.getContainer();
        boolean explode = false;
        for (Slot slot : c.f_38839_) {
            ItemStack stack = slot.m_7993_();
            if (!ItemUnstableIngot.checkExplosion(stack) || slot instanceof ResultSlot) continue;
            slot.m_5852_(ItemStack.f_41583_);
            explode = true;
        }
        if (!explode) {
            return;
        }
        ItemUnstableIngot.boom(e.getEntity());
    }

    @SubscribeEvent
    public static void onItemDrop(ItemTossEvent e) {
        Player p = e.getPlayer();
        ItemEntity entityItem = e.getEntity();
        ItemStack stack = entityItem.m_32055_();
        if (ItemUnstableIngot.checkExplosion(stack)) {
            ItemUnstableIngot.boom(p);
            e.setCanceled(true);
        }
    }

    public static void boom(Player player) {
        Level world = player.f_19853_;
        world.m_46511_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, Explosion.BlockInteraction.NONE);
        player.m_6469_(DIVIDE_BY_DIAMOND, 100.0f);
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        int blue;
        int red;
        int green;
        if (!stack.m_41782_()) {
            return 0xFFFFFF;
        }
        CompoundTag nbt = stack.m_41783_();
        int color = nbt.m_128451_("timer");
        double scale = (double)color / 200.0;
        if (scale >= 0.5) {
            green = 255;
            red = 255;
            blue = (int)((2.0 * scale - 1.0) * 255.0);
        } else if (scale >= 0.25) {
            red = 255;
            green = (int)(2.0 * scale * 255.0);
            blue = 0;
        } else {
            scale *= 256.0;
            scale = Math.floor(scale);
            switch ((int)(scale %= 2.0)) {
                case 0: {
                    red = 255;
                    blue = 0;
                    green = 0;
                    break;
                }
                case 1: {
                    green = 255;
                    red = 255;
                    blue = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("thonk" + scale);
                }
            }
        }
        return (red << 16) + (green << 8) + blue;
    }

    public static boolean checkExplosion(ItemStack stack) {
        return stack.m_41782_() && stack.m_41720_() instanceof ItemUnstableIngot && stack.m_41783_().m_128451_("timer") > 0;
    }
}

