/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.content.core;

import dev.ftb.ftbsba.tools.content.core.AbstractMachineBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMachineBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public AbstractMachineBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.0f, 1.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, ACTIVE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        CompoundTag tag;
        if (level != null && (tag = stack.m_41737_("BlockEntityTag")) != null) {
            FluidStack fluidStack;
            int energy = tag.m_128451_("energy");
            if (energy > 0) {
                list.add((Component)Component.m_237110_((String)"ftbsba.tooltip.energy", (Object[])new Object[]{energy}));
            }
            if (!(fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid"))).isEmpty()) {
                list.add((Component)Component.m_237110_((String)"ftbsba.tooltip.fluid", (Object[])new Object[]{fluidStack.getAmount(), fluidStack.getDisplayName()}));
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.f_46443_) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractMachineBlockEntity) {
                AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
                if (AbstractMachineBlock.doFluidInteraction(machine, result.m_82434_(), player, hand, true)) {
                    level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (AbstractMachineBlock.doFluidInteraction(machine, result.m_82434_(), player, hand, false)) {
                    level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
            if (blockEntity instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menuProvider, (BlockPos)pos);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level arg, BlockState arg2, BlockEntityType<T> arg3) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof AbstractMachineBlockEntity) {
                AbstractMachineBlockEntity tickable = (AbstractMachineBlockEntity)t;
                if (level1.m_5776_()) {
                    tickable.tickClient();
                } else {
                    tickable.tickServer();
                }
            }
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
            machine.dropItemContents();
        }
        super.m_6810_(state, level, pos, newState, bl);
    }

    private static boolean doFluidInteraction(BlockEntity te, Direction face, Player player, InteractionHand hand, boolean isInserting) {
        ItemStack stack = player.m_21120_(hand);
        return FluidUtil.getFluidHandler((ItemStack)stack).map(stackHandler -> {
            if (te.getCapability(ForgeCapabilities.FLUID_HANDLER, face).isPresent()) {
                if (stackHandler.getTanks() == 0) {
                    return false;
                }
                int capacity = stackHandler.getTankCapacity(0);
                return te.getCapability(ForgeCapabilities.FLUID_HANDLER, face).map(handler -> {
                    FluidActionResult result;
                    PlayerInvWrapper invWrapper = new PlayerInvWrapper(player.m_150109_());
                    FluidActionResult fluidActionResult = result = isInserting ? FluidUtil.tryEmptyContainerAndStow((ItemStack)player.m_21120_(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (Player)player, (boolean)true) : FluidUtil.tryFillContainerAndStow((ItemStack)player.m_21120_(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (Player)player, (boolean)true);
                    if (result.isSuccess()) {
                        player.m_21008_(hand, result.getResult());
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            return false;
        }).orElse(false);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }
}

