/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.content.supercooler;

import com.google.common.collect.Sets;
import dev.ftb.ftbsba.tools.ToolsRegistry;
import dev.ftb.ftbsba.tools.content.core.AbstractMachineBlockEntity;
import dev.ftb.ftbsba.tools.content.core.EmittingEnergy;
import dev.ftb.ftbsba.tools.content.core.EmittingFluidTank;
import dev.ftb.ftbsba.tools.content.core.FluidEnergyProcessorContainerData;
import dev.ftb.ftbsba.tools.content.core.IOStackHandler;
import dev.ftb.ftbsba.tools.content.core.RecipeCaches;
import dev.ftb.ftbsba.tools.content.supercooler.SuperCoolerContainer;
import dev.ftb.ftbsba.tools.recipies.SuperCoolerRecipe;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperCoolerBlockEntity
extends AbstractMachineBlockEntity {
    private final EmittingEnergy energyHandler = new EmittingEnergy(1000000, 10000, 10000, energy -> this.m_6596_());
    private final EmittingFluidTank fluidHandler = new EmittingFluidTank(10000, tank -> this.m_6596_());
    private final IOStackHandler itemHandler = new IOStackHandler(3, 1, (container, ioType) -> this.itemHandlerChanged((IOStackHandler.IO)((Object)ioType)));
    private final LazyOptional<EmittingEnergy> energy = LazyOptional.of(() -> this.energyHandler);
    private final LazyOptional<IFluidTank> tank = LazyOptional.of(() -> this.fluidHandler);
    private final LazyOptional<IOStackHandler> ioWrapper = LazyOptional.of(() -> this.itemHandler);
    private final FluidEnergyProcessorContainerData containerData = new FluidEnergyProcessorContainerData(this, this);
    private int progress = 0;
    private int progressRequired = 0;
    private boolean recheckRecipe = false;
    private SuperCoolerRecipe currentRecipe = null;
    private ResourceLocation pendingRecipeId = null;
    boolean tickLock = false;

    public SuperCoolerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ToolsRegistry.SUPER_COOLER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public IOStackHandler getItemHandler() {
        return this.itemHandler;
    }

    private void itemHandlerChanged(IOStackHandler.IO ioType) {
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            if (ioType == IOStackHandler.IO.INPUT) {
                this.recheckRecipe = true;
            }
        }
    }

    @Override
    public void tickServer() {
        if (this.tickLock) {
            return;
        }
        if (!(this.hasEnoughEnergy() && this.hasAnyFluid() && this.hasItemInAnySlot())) {
            this.setActive(false);
            this.progress = 0;
            return;
        }
        if (this.pendingRecipeId != null) {
            this.f_58857_.m_7465_().m_44043_(this.pendingRecipeId).ifPresent(r -> {
                if (r instanceof SuperCoolerRecipe) {
                    SuperCoolerRecipe s;
                    this.currentRecipe = s = (SuperCoolerRecipe)r;
                }
            });
            this.pendingRecipeId = null;
        }
        if (this.recheckRecipe || this.progress == 0) {
            this.recheckRecipe = false;
            this.currentRecipe = RecipeCaches.SUPER_COOLER.getCachedRecipe(this::findValidRecipe, this.itemHandler, (IFluidHandler)this.fluidHandler).orElse(null);
            if (this.currentRecipe == null) {
                this.progress = 0;
                this.setActive(false);
                return;
            }
            this.progress = Math.max(1, this.progress);
            this.progressRequired = this.currentRecipe.energyComponent.ticksToProcess();
        }
        if (this.currentRecipe != null) {
            if (this.progress == this.progressRequired && this.canAcceptOutput(this.currentRecipe)) {
                this.executeRecipe();
            } else if (this.progress < this.progressRequired) {
                if (this.fluidHandler.getFluid().containsFluid(this.currentRecipe.fluidIngredient)) {
                    this.setActive(true);
                    this.useEnergy();
                    ++this.progress;
                } else {
                    this.setActive(false);
                }
            }
        }
    }

    public void executeRecipe() {
        if (this.currentRecipe == null) {
            this.breakProgress();
            return;
        }
        if (!this.fluidHandler.getFluid().containsFluid(this.currentRecipe.fluidIngredient)) {
            this.breakProgress();
            return;
        }
        Set requiredItems = Sets.newIdentityHashSet();
        requiredItems.addAll(this.currentRecipe.ingredients);
        ItemStackHandler inputHandler = this.itemHandler.getInput();
        BitSet extractingSlots = new BitSet(inputHandler.getSlots());
        for (Ingredient ingredient : requiredItems) {
            for (int i = 0; i < inputHandler.getSlots(); ++i) {
                if (extractingSlots.get(i) || !ingredient.test(inputHandler.getStackInSlot(i))) continue;
                if (inputHandler.extractItem(i, 1, true).m_41619_()) {
                    this.breakProgress();
                    this.currentRecipe = null;
                    return;
                }
                extractingSlots.set(i);
            }
        }
        if (extractingSlots.cardinality() == this.currentRecipe.ingredients.size()) {
            this.fluidHandler.drain(this.currentRecipe.fluidIngredient.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            for (int i = 0; i < inputHandler.getSlots(); ++i) {
                if (!extractingSlots.get(i)) continue;
                inputHandler.extractItem(i, 1, false);
            }
            this.itemHandler.getOutput().insertItem(0, this.currentRecipe.result.m_41777_(), false);
            this.breakProgress();
        }
    }

    private void useEnergy() {
        if (this.currentRecipe == null) {
            return;
        }
        int result = this.energyHandler.extractEnergy(this.currentRecipe.energyComponent.fePerTick(), true);
        if (result < this.currentRecipe.energyComponent.fePerTick()) {
            this.breakProgress();
            return;
        }
        this.energyHandler.extractEnergy(this.currentRecipe.energyComponent.fePerTick(), false);
    }

    private void breakProgress() {
        this.progress = 0;
        this.progressRequired = 0;
        this.currentRecipe = null;
        this.tickLock = false;
    }

    public boolean canAcceptOutput(SuperCoolerRecipe recipe) {
        int nItems;
        ItemStack outputSlot = this.itemHandler.getOutput().getStackInSlot(0);
        if (outputSlot.m_41619_()) {
            return true;
        }
        int n = nItems = this.currentRecipe == null ? 0 : this.currentRecipe.result.m_41613_();
        if (outputSlot.m_41613_() >= outputSlot.m_41741_() - nItems) {
            return false;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)outputSlot, (ItemStack)recipe.result);
    }

    private boolean hasAnyFluid() {
        return !this.fluidHandler.isEmpty();
    }

    private boolean hasEnoughEnergy() {
        return this.energyHandler.getEnergyStored() > (this.currentRecipe == null ? 0 : this.currentRecipe.energyComponent.fePerTick());
    }

    private boolean hasItemInAnySlot() {
        ItemStackHandler input = this.itemHandler.getInput();
        for (int i = 0; i < input.getSlots(); ++i) {
            if (input.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private Optional<SuperCoolerRecipe> findValidRecipe() {
        return this.f_58857_.m_7465_().m_44013_((RecipeType)ToolsRegistry.SUPER_COOLER_RECIPE_TYPE.get()).stream().sorted((a, b) -> b.ingredients.size() - a.ingredients.size()).filter(this::recipeMatchesInput).findFirst();
    }

    private boolean recipeMatchesInput(SuperCoolerRecipe recipe) {
        if (!recipe.fluidIngredient.isFluidEqual(this.fluidHandler.getFluid())) {
            return false;
        }
        Set inputSet = Sets.newIdentityHashSet();
        inputSet.addAll(recipe.ingredients);
        int found = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            Iterator iter = inputSet.iterator();
            while (iter.hasNext()) {
                Ingredient ingr = (Ingredient)iter.next();
                if (!ingr.test(this.itemHandler.getStackInSlot(i))) continue;
                iter.remove();
                ++found;
                break;
            }
            if (found != recipe.ingredients.size()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.ioWrapper.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tank.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.ftbsba.super_cooler");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory arg, Player arg2) {
        return new SuperCoolerContainer(i, arg, this.m_58899_());
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.ioWrapper.invalidate();
        this.energy.invalidate();
        this.tank.invalidate();
    }

    public void m_142466_(CompoundTag arg) {
        super.m_142466_(arg);
        this.itemHandler.getInput().deserializeNBT(arg.m_128469_("input"));
        this.itemHandler.getOutput().deserializeNBT(arg.m_128469_("output"));
        this.energyHandler.deserializeNBT(arg.m_128423_("energy"));
        this.fluidHandler.readFromNBT(arg.m_128469_("fluid"));
        this.progress = arg.m_128451_("progress");
        this.progressRequired = arg.m_128451_("progressRequired");
        if (arg.m_128441_("recipe")) {
            try {
                this.pendingRecipeId = new ResourceLocation(arg.m_128461_("recipe"));
            }
            catch (ResourceLocationException e) {
                this.pendingRecipeId = null;
            }
        }
    }

    protected void m_183515_(CompoundTag arg) {
        super.m_183515_(arg);
        arg.m_128365_("input", (Tag)this.itemHandler.getInput().serializeNBT());
        arg.m_128365_("output", (Tag)this.itemHandler.getOutput().serializeNBT());
        arg.m_128365_("energy", this.energyHandler.serializeNBT());
        arg.m_128365_("fluid", (Tag)this.fluidHandler.writeToNBT(new CompoundTag()));
        arg.m_128405_("progress", this.progress);
        arg.m_128405_("progressRequired", this.progressRequired);
        if (this.currentRecipe != null) {
            arg.m_128359_("recipe", this.currentRecipe.m_6423_().toString());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public int getEnergy() {
        return this.energyHandler.getEnergyStored();
    }

    @Override
    public int getMaxEnergy() {
        return this.energyHandler.getMaxEnergyStored();
    }

    @Override
    public FluidStack getFluid() {
        return this.fluidHandler.getFluid();
    }

    @Override
    public int getMaxFluid() {
        return this.fluidHandler.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyHandler.overrideEnergy(energy);
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.fluidHandler.setFluid(fluid);
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return this.progressRequired;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public void setMaxProgress(int maxProgress) {
        this.progressRequired = maxProgress;
    }

    @Override
    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public void syncFluidTank() {
        this.fluidHandler.sync(this);
    }
}

