/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.integration.jei;

import dev.ftb.ftbsba.tools.ToolsRegistry;
import dev.ftb.ftbsba.tools.content.fusion.FusingMachineContainer;
import dev.ftb.ftbsba.tools.content.fusion.FusingMachineScreen;
import dev.ftb.ftbsba.tools.content.supercooler.SuperCoolerContainer;
import dev.ftb.ftbsba.tools.content.supercooler.SuperCoolerScreen;
import dev.ftb.ftbsba.tools.integration.jei.CrookCategory;
import dev.ftb.ftbsba.tools.integration.jei.FusingMachineCategory;
import dev.ftb.ftbsba.tools.integration.jei.HammerCategory;
import dev.ftb.ftbsba.tools.integration.jei.SuperCoolerCategory;
import dev.ftb.ftbsba.tools.recipies.NoInventory;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation FTBSBTOOLS_JEI = new ResourceLocation("ftbsba", "jei");
    public static final Set<RegistryObject<? extends Item>> HAMMERS = (Set)Util.m_137469_(new LinkedHashSet(), set -> {
        set.add(ToolsRegistry.STONE_HAMMER);
        set.add(ToolsRegistry.IRON_HAMMER);
        set.add(ToolsRegistry.GOLD_HAMMER);
        set.add(ToolsRegistry.DIAMOND_HAMMER);
        set.add(ToolsRegistry.NETHERITE_HAMMER);
        set.add(ToolsRegistry.IRON_AUTO_HAMMER_BLOCK_ITEM);
        set.add(ToolsRegistry.GOLD_AUTO_HAMMER_BLOCK_ITEM);
        set.add(ToolsRegistry.DIAMOND_AUTO_HAMMER_BLOCK_ITEM);
        set.add(ToolsRegistry.NETHERITE_AUTO_HAMMER_BLOCK_ITEM);
    });
    public static final Set<RegistryObject<Item>> CROOKS = (Set)Util.m_137469_(new HashSet(), set -> set.add(ToolsRegistry.CROOK));

    public ResourceLocation getPluginUid() {
        return FTBSBTOOLS_JEI;
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        r.addRecipeCategories(new IRecipeCategory[]{new HammerCategory(r.getJeiHelpers().getGuiHelper())});
        r.addRecipeCategories(new IRecipeCategory[]{new CrookCategory(r.getJeiHelpers().getGuiHelper())});
        r.addRecipeCategories(new IRecipeCategory[]{new FusingMachineCategory(r.getJeiHelpers().getGuiHelper())});
        r.addRecipeCategories(new IRecipeCategory[]{new SuperCoolerCategory(r.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration r) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        r.addRecipes(HammerCategory.TYPE, level.m_7465_().m_44056_((net.minecraft.world.item.crafting.RecipeType)ToolsRegistry.HAMMER_RECIPE_TYPE.get(), (Container)NoInventory.INSTANCE, (Level)level));
        r.addRecipes(CrookCategory.TYPE, level.m_7465_().m_44056_((net.minecraft.world.item.crafting.RecipeType)ToolsRegistry.CROOK_RECIPE_TYPE.get(), (Container)NoInventory.INSTANCE, (Level)level));
        r.addRecipes(FusingMachineCategory.TYPE, level.m_7465_().m_44056_((net.minecraft.world.item.crafting.RecipeType)ToolsRegistry.FUSING_MACHINE_RECIPE_TYPE.get(), (Container)NoInventory.INSTANCE, (Level)level));
        r.addRecipes(SuperCoolerCategory.TYPE, level.m_7465_().m_44056_((net.minecraft.world.item.crafting.RecipeType)ToolsRegistry.SUPER_COOLER_RECIPE_TYPE.get(), (Container)NoInventory.INSTANCE, (Level)level));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        HAMMERS.forEach(hammer -> r.addRecipeCatalyst(new ItemStack((ItemLike)hammer.get()), new RecipeType[]{HammerCategory.TYPE}));
        CROOKS.forEach(crook -> r.addRecipeCatalyst(new ItemStack((ItemLike)crook.get()), new RecipeType[]{CrookCategory.TYPE}));
        r.addRecipeCatalyst(new ItemStack((ItemLike)ToolsRegistry.FUSING_MACHINE_BLOCK_ITEM.get()), new RecipeType[]{FusingMachineCategory.TYPE});
        r.addRecipeCatalyst(new ItemStack((ItemLike)ToolsRegistry.SUPER_COOLER_BLOCK_ITEM.get()), new RecipeType[]{SuperCoolerCategory.TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(SuperCoolerContainer.class, (MenuType)ToolsRegistry.SUPER_COOLER_CONTAINER.get(), SuperCoolerCategory.TYPE, 36, 3, 0, 36);
        registration.addRecipeTransferHandler(FusingMachineContainer.class, (MenuType)ToolsRegistry.FUSING_MACHINE_CONTAINER.get(), FusingMachineCategory.TYPE, 36, 2, 0, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(SuperCoolerScreen.class, 80, 28, 22, 16, new RecipeType[]{SuperCoolerCategory.TYPE});
        registration.addRecipeClickArea(FusingMachineScreen.class, 91, 28, 22, 16, new RecipeType[]{FusingMachineCategory.TYPE});
    }
}

