/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.ftbsba.tools.ToolsTags;
import dev.ftb.ftbsba.tools.recipies.ToolsRecipeCache;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class HammerModifier
extends LootModifier {
    public static final Codec<HammerModifier> CODEC = RecordCodecBuilder.create(builder -> HammerModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, HammerModifier::new));

    public HammerModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        ItemStack hammer = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (!(entity instanceof Player && hammer != null && blockState != null && hammer.m_204117_(ToolsTags.Items.HAMMERS) && ToolsRecipeCache.hammerable(blockState))) {
            return list;
        }
        List<ItemStack> hammerDrops = ToolsRecipeCache.getHammerDrops(entity.f_19853_, new ItemStack((ItemLike)blockState.m_60734_()));
        if (hammerDrops.size() > 0) {
            list.clear();
            hammerDrops.stream().map(ItemStack::m_41777_).forEach(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

