/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.recipies;

import dev.ftb.ftbsba.tools.ToolsRegistry;
import dev.ftb.ftbsba.tools.recipies.CrookDropsResult;
import dev.ftb.ftbsba.tools.recipies.CrookRecipe;
import dev.ftb.ftbsba.tools.recipies.HammerRecipe;
import dev.ftb.ftbsba.tools.recipies.ItemWithChance;
import dev.ftb.ftbsba.tools.recipies.NoInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ToolsRecipeCache {
    public static final Set<Ingredient> crookableCache = new HashSet<Ingredient>();
    public static final Set<Ingredient> hammerableCache = new HashSet<Ingredient>();
    private static final Map<Item, CrookDropsResult> crookCache = new HashMap<Item, CrookDropsResult>();
    private static final Map<Item, List<ItemStack>> hammerCache = new HashMap<Item, List<ItemStack>>();

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)arg -> ToolsRecipeCache.refreshCaches(event.getServerResources().m_206887_())));
    }

    @SubscribeEvent
    public static void recipesSetup(RecipesUpdatedEvent event) {
        RecipeManager recipeManager = event.getRecipeManager();
        ToolsRecipeCache.refreshCaches(recipeManager);
    }

    public static void refreshCaches(RecipeManager manager) {
        ToolsRecipeCache.clearCache();
        crookableCache.addAll(manager.m_44013_((RecipeType)ToolsRegistry.CROOK_RECIPE_TYPE.get()).stream().map(e -> e.ingredient).toList());
        hammerableCache.addAll(manager.m_44013_((RecipeType)ToolsRegistry.HAMMER_RECIPE_TYPE.get()).stream().map(e -> e.ingredient).toList());
    }

    public static void clearCache() {
        crookCache.clear();
        crookableCache.clear();
        hammerCache.clear();
        hammerableCache.clear();
    }

    public static List<ItemStack> getHammerDrops(Level level, ItemStack input) {
        return hammerCache.computeIfAbsent(input.m_41720_(), key -> {
            ArrayList drops = new ArrayList();
            for (HammerRecipe recipe : level.m_7465_().m_44056_((RecipeType)ToolsRegistry.HAMMER_RECIPE_TYPE.get(), (Container)NoInventory.INSTANCE, level)) {
                if (!recipe.ingredient.test(input)) continue;
                recipe.results.forEach(e -> drops.add(e.m_41777_()));
            }
            return drops;
        });
    }

    public static boolean hammerable(BlockState state) {
        return ToolsRecipeCache.hammerable(new ItemStack((ItemLike)state.m_60734_()));
    }

    public static boolean hammerable(ItemStack stack) {
        for (Ingredient e : hammerableCache) {
            if (!e.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static CrookDropsResult getCrookDrops(Level level, ItemStack input) {
        return crookCache.computeIfAbsent(input.m_41720_(), key -> {
            ArrayList<ItemWithChance> drops = new ArrayList<ItemWithChance>();
            int max = -1;
            for (CrookRecipe recipe : level.m_7465_().m_44056_((RecipeType)ToolsRegistry.CROOK_RECIPE_TYPE.get(), (Container)NoInventory.INSTANCE, level)) {
                if (!recipe.ingredient.test(input)) continue;
                if (recipe.max > 0) {
                    max = recipe.max;
                }
                recipe.results.forEach(e -> drops.add(e.copy()));
            }
            return new CrookDropsResult(drops, max);
        });
    }

    public static boolean crookable(BlockState state) {
        return ToolsRecipeCache.crookable(new ItemStack((ItemLike)state.m_60734_()));
    }

    public static boolean crookable(ItemStack stack) {
        for (Ingredient e : crookableCache) {
            if (!e.test(stack)) continue;
            return true;
        }
        return false;
    }
}

