/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.flows;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import technicianlp.reauth.authentication.flows.AuthorizationCodeFlow;
import technicianlp.reauth.authentication.flows.DeviceCodeFlow;
import technicianlp.reauth.authentication.flows.Flow;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.impl.MicrosoftCodeFlow;
import technicianlp.reauth.authentication.flows.impl.MicrosoftDeviceFlow;
import technicianlp.reauth.authentication.flows.impl.MicrosoftProfileFlow;
import technicianlp.reauth.authentication.flows.impl.UnknownProfileFlow;
import technicianlp.reauth.authentication.http.InvalidResponseException;
import technicianlp.reauth.authentication.http.Response;
import technicianlp.reauth.authentication.http.UnreachableServiceException;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.crypto.CryptoException;

public final class Flows {
    public static Flow loginWithProfile(Profile profile, FlowCallback callback) {
        switch (profile.getValue("type")) {
            case "microsoft": {
                return new MicrosoftProfileFlow(profile, callback);
            }
        }
        return new UnknownProfileFlow(callback);
    }

    public static AuthorizationCodeFlow loginWithAuthCode(boolean persist, FlowCallback callback) {
        return new MicrosoftCodeFlow(persist, callback);
    }

    public static DeviceCodeFlow loginWithDeviceCode(boolean persist, FlowCallback callback) {
        return new MicrosoftDeviceFlow(persist, callback);
    }

    public static String getFailureReason(Flow flow) {
        try {
            flow.getSession().getNow(null);
            return "reauth.error.none";
        }
        catch (CancellationException ce) {
            return "reauth.error.cancelled";
        }
        catch (CompletionException exception) {
            Response<?> response;
            String description;
            Throwable failure = exception.getCause();
            if (failure instanceof CryptoException) {
                return "reauth.error.crypto";
            }
            if (failure instanceof UnreachableServiceException) {
                return "reauth.error.network";
            }
            if (failure instanceof InvalidResponseException && (description = (response = ((InvalidResponseException)failure).response).getUnchecked().getErrorDescription()) != null) {
                return description;
            }
            return "reauth.error.unknown";
        }
    }
}

