/*
 * Decompiled with CFR 0.152.
 */
package io.github.persiflagetheninth.tetra_nihilo.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.persiflagetheninth.tetra_nihilo.TetraNihilo;
import io.github.persiflagetheninth.tetra_nihilo.compat.NihiloToolCompat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

public class HammerLoot
extends LootModifier {
    public static final Supplier<Codec<HammerLoot>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> HammerLoot.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, HammerLoot::new)));

    public HammerLoot(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList<ItemStack> changedLoot;
        TetraNihilo.LOGGER.debug("Fired Hammer Modifier");
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (tool != null && blockState != null && entity instanceof Player && tool.m_41720_() instanceof ItemModularHandheld && tool.canPerformAction(TetraToolActions.hammer) && NihiloToolCompat.canHammer(blockState) && !(changedLoot = NihiloToolCompat.getHammerDrops(entity.f_19853_, blockState, context.m_230907_())).isEmpty()) {
            return changedLoot;
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return null;
    }
}

