/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.item;

import alexthw.starbunclemania.starbuncle.StarHelper;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.nbt.ItemstackData;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidScroll
extends ModItem
implements IScribeable {
    public FluidScroll(Item.Properties properties) {
        super(properties);
    }

    public static boolean checkForFilters(@Nullable BlockPos pos, ItemStack scroll, FluidStack fluid, Level level) {
        FluidScroll filter;
        Item item;
        boolean scrollCheck;
        boolean bl = scrollCheck = scroll != null && (item = scroll.m_41720_()) instanceof FluidScroll && (filter = (FluidScroll)item).isDenied(scroll, fluid);
        if (pos != null) {
            return StarHelper.checkItemFramesForFluid(pos, level, scrollCheck, fluid);
        }
        return scrollCheck;
    }

    public boolean isDenied(ItemStack fluidScroll, FluidStack fluidInTank) {
        FluidData filter = new FluidData(fluidScroll);
        return !filter.containsStack(fluidInTank);
    }

    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack thisStack) {
        ItemStack container = player.m_21120_(handIn);
        FluidData scrollData = new FluidData(thisStack);
        if (container.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            IFluidHandler tank = (IFluidHandler)container.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
            return scrollData.writeWithFeedback(player, tank.getFluidInTank(0));
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        if (!stack.m_41782_()) {
            return;
        }
        FluidData scrollData = new FluidData(stack);
        for (FluidStack s : scrollData.fluids) {
            tooltip2.add(s.getDisplayName());
        }
    }

    public static class FluidData
    extends ItemstackData {
        List<FluidStack> fluids = new ArrayList<FluidStack>();

        public List<FluidStack> getFluids() {
            return this.fluids;
        }

        public FluidData(ItemStack stack) {
            super(stack);
            CompoundTag tag = this.getItemTag(stack);
            if (tag == null || tag.m_128456_()) {
                return;
            }
            for (String s : tag.m_128431_()) {
                if (!s.contains("fluid_")) continue;
                this.fluids.add(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_(s)));
            }
        }

        public boolean writeWithFeedback(Player player, FluidStack stackToWrite) {
            if (stackToWrite.isEmpty()) {
                return false;
            }
            if (this.containsStack(stackToWrite)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.scribe.item_removed"));
                return this.remove(stackToWrite);
            }
            if (this.add(stackToWrite)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.scribe.item_added"));
                return true;
            }
            return false;
        }

        private boolean remove(FluidStack stackToWrite) {
            boolean added = this.fluids.removeIf(arg_0 -> ((FluidStack)stackToWrite).isFluidEqual(arg_0));
            this.writeItem();
            return added;
        }

        private boolean add(FluidStack stackToWrite) {
            boolean added = this.fluids.add(stackToWrite.copy());
            this.writeItem();
            return added;
        }

        public boolean containsStack(FluidStack stackToWrite) {
            return this.fluids.stream().anyMatch(arg_0 -> ((FluidStack)stackToWrite).isFluidEqual(arg_0));
        }

        public String getTagString() {
            return "sb_fluidScrollData";
        }

        public String getKey(FluidStack stack) {
            return "fluid_" + ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString();
        }

        public void writeToNBT(CompoundTag tag) {
            for (FluidStack s : this.fluids) {
                CompoundTag fluidTag = new CompoundTag();
                s.writeToNBT(fluidTag);
                tag.m_128365_(this.getKey(s), (Tag)fluidTag);
            }
        }
    }
}

