/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.jei;

import alexthw.starbunclemania.jei.StarPlugin;
import alexthw.starbunclemania.recipe.FluidSourcelinkRecipe;
import alexthw.starbunclemania.registry.ModRegistry;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.client.jei.JEIConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidLinkRecipeCategory
implements IRecipeCategory<FluidSourcelinkRecipe> {
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    public IDrawable background;
    public IDrawable icon;

    public FluidLinkRecipeCategory(final IGuiHelper helper) {
        this.background = helper.createBlankDrawable(120, 32);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ModRegistry.FLUID_SOURCELINK.get()).m_5456_().m_7968_());
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(JEIConstants.RECIPE_GUI_VANILLA, 82, 128, 24, 32).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public RecipeType<FluidSourcelinkRecipe> getRecipeType() {
        return StarPlugin.FLUID_SOURCELINK;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Fluid Sourcelink conversion");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidSourcelinkRecipe recipe, IFocusGroup focuses) {
        ResourceLocation fluid_name = recipe.getFluidType();
        try {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getDelegateOrThrow(fluid_name).get();
            builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).setFluidRenderer(1000L, false, 16, 24).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(fluid, 1000));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void draw(FluidSourcelinkRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)40);
        arrow.draw(matrixStack, 25, 10);
        Font renderer = Minecraft.m_91087_().f_91062_;
        double ratio = recipe.getConversion_ratio() * 1000.0;
        renderer.m_92883_(matrixStack, String.format("%.0f Source", ratio), 55.0f, 12.0f, 0);
    }
}

