/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.energy;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.starbuncle.energy.StarbyEnergyBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyStoreGoal
extends GoToPosGoal<StarbyEnergyBehavior> {
    public EnergyStoreGoal(Starbuncle starbuncle, StarbyEnergyBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> behavior.getEnergy() > 0);
    }

    public void m_8056_() {
        super.m_8056_();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
    }

    @Nullable
    public BlockPos getDestination() {
        return ((StarbyEnergyBehavior)this.behavior).getBatteryForStore();
    }

    public boolean onDestinationReached() {
        this.starbuncle.getNavigation().m_26573_();
        IEnergyStorage batteryTile = ((StarbyEnergyBehavior)this.behavior).getHandlerFromCap(this.targetPos);
        if (batteryTile == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoEnergyHandler", "No energy handler at " + this.targetPos.toString()));
            return true;
        }
        int room = batteryTile.getMaxEnergyStored() - batteryTile.getEnergyStored();
        if (room <= (Integer)Configs.STARBATTERY_THRESHOLD.get()) {
            this.starbuncle.setBackOff(5 + this.starbuncle.f_19853_.f_46441_.m_188503_(20));
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("no_room", this.targetPos.toString()));
            return true;
        }
        int diff = Math.min(room, ((StarbyEnergyBehavior)this.behavior).getEnergy());
        int actualTake = batteryTile.receiveEnergy(diff, false);
        ((StarbyEnergyBehavior)this.behavior).setEnergy(((StarbyEnergyBehavior)this.behavior).getEnergy() - actualTake);
        this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("stored_energy", "successful at " + this.targetPos.toString() + ". Trasferred RFs : " + actualTake));
        return true;
    }
}

