/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.energy;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.common.item.DirectionScroll;
import alexthw.starbunclemania.starbuncle.StarHelper;
import alexthw.starbunclemania.starbuncle.energy.EnergyExtractGoal;
import alexthw.starbunclemania.starbuncle.energy.EnergyStoreGoal;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class StarbyEnergyBehavior
extends StarbyListBehavior {
    public static final ResourceLocation TRANSPORT_ID = new ResourceLocation("ars_nouveau", "starby_energy_transport");
    private int energy = 0;
    public int side = -1;

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public StarbyEnergyBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.m_128441_("Direction")) {
            this.side = tag.m_128451_("Direction");
        }
        if (tag.m_128441_("battery")) {
            this.energy = tag.m_128451_("battery");
        }
        this.goals.add(new WrappedGoal(3, (Goal)new EnergyExtractGoal(entity, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new EnergyStoreGoal(entity, this)));
    }

    public boolean canGoToBed() {
        return this.isBedPowered() || (this.getBatteryForTake() == null || this.energy > (Integer)Configs.STARBATTERY_THRESHOLD.get()) && (this.energy == 0 || this.getBatteryForStore() == null);
    }

    @Nullable
    public static IEnergyStorage getHandlerFromCap(BlockPos pos, Level level, int sideOrdinal) {
        BlockEntity be = level.m_7702_(pos);
        Direction side = (sideOrdinal = StarHelper.checkItemFramesForSide(pos, level, sideOrdinal, be)) < 0 ? Direction.UP : Direction.values()[sideOrdinal];
        return be != null && be.getCapability(ForgeCapabilities.ENERGY, side).isPresent() && be.getCapability(ForgeCapabilities.ENERGY, side).resolve().isPresent() ? (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, side).resolve().get() : null;
    }

    public IEnergyStorage getHandlerFromCap(BlockPos pos) {
        return StarbyEnergyBehavior.getHandlerFromCap(pos, this.level, this.side);
    }

    @Nullable
    public BlockPos getBatteryForTake() {
        for (BlockPos pos : this.FROM_LIST) {
            if (!this.isPositionValidTake(pos)) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    public BlockPos getBatteryForStore() {
        for (BlockPos pos : this.TO_LIST) {
            if (!this.isPositionValidStore(pos)) continue;
            return pos;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null) {
            return false;
        }
        IEnergyStorage battery = this.getHandlerFromCap(p);
        if (battery != null) {
            return battery.canExtract() && battery.getEnergyStored() >= 0;
        }
        return false;
    }

    public boolean isPositionValidStore(BlockPos p) {
        if (p == null) {
            return false;
        }
        IEnergyStorage battery = this.getHandlerFromCap(p);
        if (battery != null) {
            return battery.canReceive() && battery.receiveEnergy(this.getRatio(), true) >= (Integer)Configs.STARBATTERY_THRESHOLD.get();
        }
        return false;
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity be;
        super.onFinishedConnectionFirst(storedPos, storedEntity, playerEntity);
        if (storedPos != null && (be = this.level.m_7702_(storedPos)) != null && (be.getCapability(ForgeCapabilities.ENERGY).isPresent() || this.getHandlerFromCap(storedPos) != null)) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.energy_to"));
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity be;
        super.onFinishedConnectionLast(storedPos, storedEntity, playerEntity);
        if (storedPos != null && (be = this.level.m_7702_(storedPos)) != null && (be.getCapability(ForgeCapabilities.ENERGY).isPresent() || this.getHandlerFromCap(storedPos) != null)) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.energy_from"));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof DirectionScroll && stack.m_41782_()) {
            this.side = stack.m_41784_().m_128451_("side");
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.filter_set"));
            this.syncTag();
        }
        return super.mobInteract(player, hand);
    }

    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.storing_energy", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.taking_energy", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (this.side >= 0) {
            tooltip.add((Component)Component.m_237113_((String)("Preferred Side : " + Direction.values()[this.side].name())));
        }
    }

    public CompoundTag toTag(CompoundTag tag) {
        tag.m_128405_("battery", this.energy);
        if (this.side >= 0) {
            tag.m_128405_("Direction", this.side);
        }
        return super.toTag(tag);
    }

    public int getRatio() {
        return (Integer)Configs.STARBATTERY_RATIO.get();
    }

    protected ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public ItemStack getStackForRender() {
        return ItemStack.f_41583_;
    }
}

