/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.item;

import alexthw.starbunclemania.common.item.DirectionScroll;
import alexthw.starbunclemania.starbuncle.StarHelper;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class AdvancedItemTransportBehavior
extends StarbyTransportBehavior {
    public static final ResourceLocation TRANSPORT_ID = new ResourceLocation("starbunclemania", "starby_adv_item_transport");
    public int side = -1;

    public AdvancedItemTransportBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.m_128441_("Direction")) {
            this.side = tag.m_128451_("Direction");
        }
    }

    public void onWanded(Player playerEntity) {
        if (this.starbuncle.getCosmeticItem().m_41619_()) {
            this.starbuncle.dynamicBehavior = new StarbyTransportBehavior(this.starbuncle, new CompoundTag());
        }
        super.onWanded(playerEntity);
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null && playerEntity.f_19853_.m_8055_(storedPos).m_204336_(BlockTagProvider.SUMMON_SLEEPABLE)) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.set_bed"));
            this.starbuncle.data.bedPos = storedPos.m_7949_();
        }
        if (storedPos == null) {
            return;
        }
        BlockEntity blockEntity = this.level.m_7702_(storedPos);
        if (blockEntity != null && (blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() || this.getItemCapFromTile(blockEntity) != null)) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.store"));
            this.addToPos(storedPos);
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null) {
            return;
        }
        BlockEntity blockEntity = this.level.m_7702_(storedPos);
        if (blockEntity != null && (blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() || this.getItemCapFromTile(blockEntity) != null)) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.take"));
            this.addFromPos(storedPos);
        }
    }

    protected ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof DirectionScroll && stack.m_41782_()) {
            this.side = stack.m_41784_().m_128451_("side");
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.filter_set"));
            this.syncTag();
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public IItemHandler getItemCapFromTile(BlockEntity be) {
        if (be == null) {
            return null;
        }
        int sideOrdinal = StarHelper.checkItemFramesForSide(be.m_58899_(), this.level, this.side, be);
        Direction side = sideOrdinal < 0 ? Direction.UP : Direction.values()[sideOrdinal];
        return be.getCapability(ForgeCapabilities.ITEM_HANDLER, side).isPresent() && be.getCapability(ForgeCapabilities.ITEM_HANDLER, side).resolve().isPresent() ? (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, side).resolve().get() : null;
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (this.side >= 0) {
            tag.m_128405_("Direction", this.side);
        }
        return super.toTag(tag);
    }

    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        if (this.side >= 0) {
            tooltip.add((Component)Component.m_237113_((String)("Preferred Side : " + Direction.values()[this.side].name())));
        }
    }
}

