/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.conveyor;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.conveyor.ConveyorSpeed;
import com.lothrazar.cyclic.block.conveyor.ConveyorType;
import com.lothrazar.cyclic.block.conveyor.TileConveyor;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockConveyor
extends BlockCyclic
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final int MAX_CONNECTED_UPDATE = 16;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape AG00 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.8, (double)16.0);
    protected static final VoxelShape AG01 = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape AG02 = Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape AG03 = Block.m_49796_((double)3.0, (double)2.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape AG04 = Block.m_49796_((double)4.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape AG05 = Block.m_49796_((double)5.0, (double)4.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    protected static final VoxelShape AG06 = Block.m_49796_((double)6.0, (double)5.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    protected static final VoxelShape AG07 = Block.m_49796_((double)7.0, (double)6.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape AG08 = Block.m_49796_((double)8.0, (double)7.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape AG09 = Block.m_49796_((double)9.0, (double)8.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape AG10 = Block.m_49796_((double)10.0, (double)9.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape AG11 = Block.m_49796_((double)11.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape AG12 = Block.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape AG13 = Block.m_49796_((double)13.0, (double)12.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape AG14 = Block.m_49796_((double)14.0, (double)13.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape AG15 = Block.m_49796_((double)15.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape AG16 = Block.m_49796_((double)15.5, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape ANGLEEAST = Shapes.m_83124_((VoxelShape)AG00, (VoxelShape[])new VoxelShape[]{AG01, AG02, AG03, AG04, AG05, AG06, AG07, AG08, AG09, AG10, AG11, AG12, AG13, AG14, AG15, AG16});
    protected static final VoxelShape ANGLESOUTH = Shapes.m_83124_((VoxelShape)BlockConveyor.rot(AG00), (VoxelShape[])new VoxelShape[]{BlockConveyor.rot(AG01), BlockConveyor.rot(AG02), BlockConveyor.rot(AG03), BlockConveyor.rot(AG04), BlockConveyor.rot(AG05), BlockConveyor.rot(AG06), BlockConveyor.rot(AG07), BlockConveyor.rot(AG08), BlockConveyor.rot(AG09), BlockConveyor.rot(AG10), BlockConveyor.rot(AG11), BlockConveyor.rot(AG12), BlockConveyor.rot(AG13), BlockConveyor.rot(AG14), BlockConveyor.rot(AG15), BlockConveyor.rot(AG16)});
    protected static final VoxelShape ANGLENORTH = Shapes.m_83124_((VoxelShape)BlockConveyor.flipx(AG00), (VoxelShape[])new VoxelShape[]{BlockConveyor.flipx(AG01), BlockConveyor.flipx(AG02), BlockConveyor.flipx(AG03), BlockConveyor.flipx(AG04), BlockConveyor.flipx(AG05), BlockConveyor.flipx(AG06), BlockConveyor.flipx(AG07), BlockConveyor.flipx(AG08), BlockConveyor.flipx(AG09), BlockConveyor.flipx(AG10), BlockConveyor.flipx(AG11), BlockConveyor.flipx(AG12), BlockConveyor.flipx(AG13), BlockConveyor.flipx(AG14), BlockConveyor.flipx(AG15), BlockConveyor.flipx(AG16)});
    protected static final VoxelShape ANGLEWEST = Shapes.m_83124_((VoxelShape)BlockConveyor.flipz(AG00), (VoxelShape[])new VoxelShape[]{BlockConveyor.flipz(AG01), BlockConveyor.flipz(AG02), BlockConveyor.flipz(AG03), BlockConveyor.flipz(AG04), BlockConveyor.flipz(AG05), BlockConveyor.flipz(AG06), BlockConveyor.flipz(AG07), BlockConveyor.flipz(AG08), BlockConveyor.flipz(AG09), BlockConveyor.flipz(AG10), BlockConveyor.flipz(AG11), BlockConveyor.flipz(AG12), BlockConveyor.flipz(AG13), BlockConveyor.flipz(AG14), BlockConveyor.flipz(AG15), BlockConveyor.flipz(AG16)});
    public static final EnumProperty<DyeColor> COLOUR = EnumProperty.m_61587_((String)"colour", DyeColor.class);
    public static final EnumProperty<ConveyorType> TYPE = EnumProperty.m_61587_((String)"type", ConveyorType.class);
    public static final EnumProperty<ConveyorSpeed> SPEED = EnumProperty.m_61587_((String)"speed", ConveyorSpeed.class);
    public static final List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> STATE_PAIRS = BlockConveyor.generateStatePairs();

    public BlockConveyor(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(0.6f).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape rot(VoxelShape shape) {
        double x1 = shape.m_83288_(Direction.Axis.X);
        double x2 = shape.m_83297_(Direction.Axis.X);
        double y1 = shape.m_83288_(Direction.Axis.Y);
        double y2 = shape.m_83297_(Direction.Axis.Y);
        double z1 = shape.m_83288_(Direction.Axis.Z);
        double z2 = shape.m_83297_(Direction.Axis.Z);
        double temp = z1;
        z1 = x1;
        x1 = temp;
        temp = z2;
        z2 = x2;
        x2 = temp;
        x1 = 1.0 - x1;
        x2 = 1.0 - x2;
        return BlockConveyor.safeShapeBox(x1, x2, y1, y2, z1, z2);
    }

    private static VoxelShape safeShapeBox(double x1, double x2, double y1, double y2, double z1, double z2) {
        double temp;
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (z1 > z2) {
            temp = z1;
            z1 = z2;
            z2 = temp;
        }
        return Shapes.m_83048_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape flipx(VoxelShape shape) {
        double x1 = shape.m_83288_(Direction.Axis.X);
        double x2 = shape.m_83297_(Direction.Axis.X);
        double y1 = shape.m_83288_(Direction.Axis.Y);
        double y2 = shape.m_83297_(Direction.Axis.Y);
        double z1 = shape.m_83288_(Direction.Axis.Z);
        double z2 = shape.m_83297_(Direction.Axis.Z);
        double temp = z1;
        z1 = x1;
        x1 = temp;
        temp = z2;
        z2 = x2;
        x2 = temp;
        z1 = 1.0 - z1;
        z2 = 1.0 - z2;
        return BlockConveyor.safeShapeBox(x1, y1, z1, x2, y2, z2);
    }

    public static VoxelShape flipz(VoxelShape shape) {
        double x1 = shape.m_83288_(Direction.Axis.X);
        double x2 = shape.m_83297_(Direction.Axis.X);
        double y1 = shape.m_83288_(Direction.Axis.Y);
        double y2 = shape.m_83297_(Direction.Axis.Y);
        double z1 = shape.m_83288_(Direction.Axis.Z);
        double z2 = shape.m_83297_(Direction.Axis.Z);
        x1 = 1.0 - x1;
        x2 = 1.0 - x2;
        z1 = 1.0 - z1;
        z2 = 1.0 - z2;
        return BlockConveyor.safeShapeBox(x1, y1, z1, x2, y2, z2);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (state.m_61143_(TYPE) == ConveyorType.UP) {
            switch (facing) {
                case EAST: {
                    return ANGLEEAST;
                }
                case NORTH: {
                    return ANGLENORTH;
                }
                case SOUTH: {
                    return ANGLESOUTH;
                }
                case WEST: {
                    return ANGLEWEST;
                }
            }
            if (state.m_61143_(TYPE) == ConveyorType.DOWN) {
                switch (facing) {
                    case EAST: {
                        return ANGLEWEST;
                    }
                    case NORTH: {
                        return ANGLESOUTH;
                    }
                    case SOUTH: {
                        return ANGLENORTH;
                    }
                    case WEST: {
                        return ANGLEEAST;
                    }
                }
            }
        }
        return SHAPE;
    }

    public boolean m_7923_(BlockState state) {
        return ((ConveyorType)((Object)state.m_61143_(TYPE))).isVertical();
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return ((ConveyorType)((Object)state.m_61143_(TYPE))).isVertical();
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> nextState;
        boolean success;
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (heldItem instanceof DyeItem) {
            DyeItem dye = (DyeItem)heldItem;
            DyeColor newc = dye.m_41089_();
            world.m_46597_(pos, (BlockState)state.m_61124_(COLOUR, (Comparable)newc));
            this.setConnectedColour(world, pos, newc, 0);
            return InteractionResult.SUCCESS;
        }
        if (heldItem == Items.f_41978_) {
            ConveyorSpeed speed = (ConveyorSpeed)((Object)state.m_61143_(SPEED));
            if (world.m_46597_(pos, (BlockState)state.m_61124_(SPEED, (Comparable)((Object)speed.getNext())))) {
                this.setConnectedSpeed(world, pos, speed.getNext(), 0);
                return InteractionResult.SUCCESS;
            }
        } else if (heldStack.m_204117_(DataTags.WRENCH) && (success = world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(TYPE, (Comparable)((Object)(nextState = BlockConveyor.nextConnectedState((ConveyorType)((Object)state.m_61143_(TYPE)), (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))).getKey()))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)nextState.getValue())))) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private BlockState getClosestConnected(Level world, BlockPos pos) {
        for (Direction d : Direction.values()) {
            BlockPos offset = pos.m_121945_(d);
            BlockState here = world.m_8055_(offset);
            if (here.m_60734_() != this) continue;
            return here;
        }
        return null;
    }

    private void setConnectedColour(Level world, BlockPos pos, DyeColor speedIn, int maxRecursive) {
        if (maxRecursive > 16) {
            return;
        }
        for (Direction d : Direction.values()) {
            BlockPos offset = pos.m_121945_(d);
            BlockState here = world.m_8055_(offset);
            if (here.m_60734_() != this) continue;
            world.m_46597_(offset, (BlockState)here.m_61124_(COLOUR, (Comparable)speedIn));
            this.setConnectedColour(world, offset, speedIn, ++maxRecursive);
        }
    }

    private void setConnectedSpeed(Level world, BlockPos pos, ConveyorSpeed speedIn, int maxRecursive) {
        if (maxRecursive > 16) {
            return;
        }
        for (Direction d : Direction.values()) {
            BlockPos offset = pos.m_121945_(d);
            BlockState here = world.m_8055_(offset);
            if (here.m_60734_() != this || !world.m_46597_(offset, (BlockState)here.m_61124_(SPEED, (Comparable)((Object)speedIn)))) continue;
            this.setConnectedSpeed(world, offset, speedIn, ++maxRecursive);
        }
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileConveyor(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockConveyor.m_152132_(type, (BlockEntityType)((BlockEntityType)TileRegistry.CONVEYOR.get()), (BlockEntityTicker)(world.f_46443_ ? TileConveyor::clientTick : TileConveyor::serverTick));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        ConveyorSpeed speed = ConveyorSpeed.MEDIUM;
        ConveyorType type = ConveyorType.STRAIGHT;
        DyeColor col = DyeColor.GRAY;
        BlockState nearby = this.getClosestConnected(world, pos);
        if (nearby != null) {
            speed = (ConveyorSpeed)((Object)nearby.m_61143_(SPEED));
            col = (DyeColor)nearby.m_61143_(COLOUR);
        }
        Direction facing = placer != null ? placer.m_6350_() : Direction.NORTH;
        world.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing)).m_61124_(SPEED, (Comparable)((Object)speed))).m_61124_(TYPE, (Comparable)((Object)type))).m_61124_(COLOUR, (Comparable)col), 2);
        super.m_6402_(world, pos, state, placer, stack);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_}).m_61104_(new Property[]{SPEED}).m_61104_(new Property[]{TYPE}).m_61104_(new Property[]{COLOUR}).m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> nextState(ConveyorType t, Direction d) {
        AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> pair = new AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>(t, d);
        if (STATE_PAIRS.contains(pair)) {
            int index = STATE_PAIRS.indexOf(pair) + 1;
            return BlockConveyor.nextState(STATE_PAIRS, index);
        }
        return pair;
    }

    public static AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> nextConnectedState(ConveyorType t, Direction d) {
        AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> pair2;
        List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> connectedStates = STATE_PAIRS.stream().filter(pair -> pair.getValue() == d).collect(Collectors.toList());
        if (connectedStates.contains(pair2 = new AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>(t, d))) {
            int index = connectedStates.indexOf(pair2) + 1;
            return BlockConveyor.nextState(connectedStates, index);
        }
        return pair2;
    }

    private static AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> nextState(List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> list, int index) {
        return list.get(BlockConveyor.nextIndex(list, index));
    }

    private static int nextIndex(List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> list, int index) {
        return index >= list.size() ? index % list.size() : index;
    }

    public static List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> generateStatePairs() {
        LinkedList<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> pairs = new LinkedList<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>>();
        for (ConveyorType t : ConveyorType.values()) {
            for (Direction d : BlockStateProperties.f_61374_.m_6908_()) {
                pairs.add(new AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>(t, d));
            }
        }
        return pairs;
    }
}

