/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.laser;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.laser.TileLaser;
import com.lothrazar.cyclic.render.FakeBlockRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;

public class RenderLaser
implements BlockEntityRenderer<TileLaser> {
    public RenderLaser(BlockEntityRendererProvider.Context d) {
    }

    public void render(TileLaser te, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int partialTicks, int destroyStage) {
        if (te.requiresRedstone() && !te.isPowered()) {
            return;
        }
        try {
            RenderLaser.draw(te, matrixStack, iRenderTypeBuffer);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("RenderLaser.java ", e);
        }
    }

    public static Vector3f adjustBeamToEyes(Vector3f from, Vector3f to, BlockPos tile) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vector3f vectP = new Vector3f((float)player.m_20185_() - (float)tile.m_123341_(), (float)player.m_20188_() - (float)tile.m_123342_(), (float)player.m_20189_() - (float)tile.m_123343_());
        Vector3f vectS = from.m_122281_();
        vectS.m_122267_(vectP);
        Vector3f vectE = to.m_122281_();
        vectE.m_122267_(from);
        Vector3f adjustedVec = vectS.m_122281_();
        adjustedVec.m_122279_(vectE);
        adjustedVec.m_122278_();
        return adjustedVec;
    }

    public static void draw(TileLaser tile, PoseStack matrixStackIn, MultiBufferSource bufferIn) throws Exception {
        BlockPos posTarget = tile.getPosTarget();
        if (posTarget == null || posTarget.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_85861_();
        BlockPos tilePos = tile.m_58899_();
        Vector3f from = new Vector3f((float)posTarget.m_123341_() + 0.5f - (float)tilePos.m_123341_(), (float)posTarget.m_123342_() + 0.5f - (float)tilePos.m_123342_(), (float)posTarget.m_123343_() + 0.5f - (float)tilePos.m_123343_());
        Vector3f to = new Vector3f(tile.xOffset.getOffset(), tile.yOffset.getOffset(), tile.zOffset.getOffset());
        VertexConsumer builder = bufferIn.m_6299_(FakeBlockRenderTypes.LASER_MAIN_BEAM);
        RenderLaser.drawDirewolfLaser(builder, positionMatrix, from, to, tile.getRed(), tile.getGreen(), tile.getBlue(), tile.getAlpha(), tile.getThick(), tilePos);
        float coreThick = 0.01f;
        RenderLaser.drawDirewolfLaser(builder, positionMatrix, from, to, 1.0f, 1.0f, 1.0f, tile.getAlpha(), 0.01f, tilePos);
        matrixStackIn.m_85849_();
    }

    public static void drawDirewolfLaser(VertexConsumer builder, Matrix4f positionMatrix, Vector3f from, Vector3f to, float r, float g, float b, float alpha, float thickness, BlockPos tilePos) {
        float v = 1.0f;
        Vector3f adjustedVec = RenderLaser.adjustBeamToEyes(from, to, tilePos);
        adjustedVec.m_122261_(thickness);
        Vector3f p1 = from.m_122281_();
        p1.m_122253_(adjustedVec);
        Vector3f p2 = from.m_122281_();
        p2.m_122267_(adjustedVec);
        Vector3f p3 = to.m_122281_();
        p3.m_122253_(adjustedVec);
        Vector3f p4 = to.m_122281_();
        p4.m_122267_(adjustedVec);
        builder.m_85982_(positionMatrix, p1.m_122239_(), p1.m_122260_(), p1.m_122269_()).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(positionMatrix, p3.m_122239_(), p3.m_122260_(), p3.m_122269_()).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(positionMatrix, p4.m_122239_(), p4.m_122260_(), p4.m_122269_()).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(positionMatrix, p2.m_122239_(), p2.m_122260_(), p2.m_122269_()).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
    }

    public boolean shouldRenderOffScreen(TileLaser te) {
        return true;
    }
}

