/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.solidifier.ContainerSolidifier;
import com.lothrazar.cyclic.block.solidifier.RecipeSolidifier;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.CyclicRecipeType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSolidifier
extends TileBlockEntityCyclic
implements MenuProvider {
    public static final int MAX = 64000;
    public static final int CAPACITY = 64000;
    public static final int TRANSFER_FLUID_PER_TICK = 50;
    private RecipeSolidifier currentRecipe;
    FluidTankBase tank;
    ItemStackHandler inputSlots = new ItemStackHandler(3);
    ItemStackHandler outputSlots = new ItemStackHandler(1);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private final LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private int burnTimeMax = 0;

    public TileSolidifier(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.SOLIDIFIER.get(), pos, state);
        this.tank = new FluidTankBase(this, 64000, p -> true);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileSolidifier e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileSolidifier e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        this.findMatchingRecipe();
        if (this.currentRecipe == null) {
            this.timer = 0;
            return;
        }
        int cost = this.currentRecipe.getEnergy().getRfPertick();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        this.energy.extractEnergy(cost, false);
        --this.timer;
        if (this.timer < 0) {
            this.timer = 0;
        }
        if (this.timer == 0 && this.tryProcessRecipe() && this.currentRecipe != null) {
            this.timer = this.currentRecipe.getEnergy().getTicks();
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case BURNMAX: {
                this.burnTimeMax = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case BURNMAX: {
                return this.burnTimeMax;
            }
        }
        return 0;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.SOLIDIFIER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerSolidifier(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inputSlots.deserializeNBT(tag.m_128469_("inv"));
        this.outputSlots.deserializeNBT(tag.m_128469_("invoutput"));
        this.burnTimeMax = tag.m_128451_("burnTimeMax");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inputSlots.serializeNBT());
        tag.m_128365_("invoutput", (Tag)this.outputSlots.serializeNBT());
        tag.m_128405_("burnTimeMax", this.burnTimeMax);
        super.m_183515_(tag);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public float getCapacity() {
        return 64000.0f;
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches(this, this.f_58857_)) {
            return;
        }
        this.currentRecipe = null;
        this.burnTimeMax = 0;
        this.timer = 0;
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)CyclicRecipeType.SOLID.get());
        for (RecipeSolidifier rec : recipes) {
            if (!rec.matches(this, this.f_58857_)) continue;
            this.currentRecipe = rec;
            this.timer = this.burnTimeMax = this.currentRecipe.getEnergy().getTicks();
            break;
        }
    }

    private boolean tryProcessRecipe() {
        FluidStack test = this.tank.drain(this.currentRecipe.getRecipeFluid().getAmount(), IFluidHandler.FluidAction.SIMULATE);
        if (test.getAmount() >= this.currentRecipe.getRecipeFluid().getAmount()) {
            if (!this.outputSlots.insertItem(0, this.currentRecipe.m_8043_(), true).m_41619_()) {
                return false;
            }
            this.inputSlots.getStackInSlot(0).m_41774_(1);
            this.inputSlots.getStackInSlot(1).m_41774_(1);
            this.inputSlots.getStackInSlot(2).m_41774_(1);
            this.tank.drain(this.currentRecipe.fluidIngredient.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.outputSlots.insertItem(0, this.currentRecipe.m_8043_(), false);
            this.updateComparatorOutputLevel();
            return true;
        }
        return false;
    }

    public ItemStack getStackInputSlot(int slot) {
        return this.inputSlots.getStackInSlot(slot);
    }

    static enum Fields {
        REDSTONE,
        TIMER,
        RENDER,
        BURNMAX;

    }
}

