/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tankcask;

import com.lothrazar.cyclic.block.tank.ItemBlockTank;
import com.lothrazar.cyclic.capabilities.item.FluidHandlerCapabilityStack;
import com.lothrazar.cyclic.util.FluidHelpers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemBlockCask
extends BlockItem {
    public ItemBlockCask(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public boolean m_142522_(ItemStack stack) {
        FluidStack fstack = ItemBlockTank.copyFluidFromStack(stack);
        return fstack != null && fstack.getAmount() > 0;
    }

    public int m_142158_(ItemStack stack) {
        try {
            FluidStack fstack = ItemBlockTank.copyFluidFromStack(stack);
            float current = fstack.getAmount();
            float max = 8000.0f;
            return Math.round(13.0f * current / max);
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    public int m_142159_(ItemStack stack) {
        FluidStack fstack = ItemBlockTank.copyFluidFromStack(stack);
        return FluidHelpers.getColorFromFluid(fstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        FluidStack fs;
        IFluidHandler storage = (IFluidHandler)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null);
        if (storage != null && (fs = storage.getFluidInTank(0)) != null && !fs.isEmpty()) {
            MutableComponent t = Component.m_237115_((String)(fs.getDisplayName().getString() + " " + fs.getAmount() + "/" + storage.getTankCapacity(0)));
            t.m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)t);
            return;
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new FluidHandlerCapabilityStack(stack, 8000);
    }
}

