/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.wireless.fluid;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.wireless.fluid.ContainerWirelessFluid;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWirelessFluid
extends TileBlockEntityCyclic
implements MenuProvider {
    public static final int CAPACITY = 64000;
    static final int MAX = 64000;
    public static final int MAX_TRANSFER = 64000;
    private int transferRate = 1000;
    public FluidTankBase tank = new FluidTankBase(this, 64000, f -> true);
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);
    public ItemStackHandler gpsSlots = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof LocationGpsCard;
        }
    };

    public TileWirelessFluid(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.WIRELESS_FLUID.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileWirelessFluid e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileWirelessFluid e) {
        e.tick();
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.WIRELESS_FLUID.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerWirelessFluid(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.gpsSlots.deserializeNBT(tag.m_128469_("inv"));
        this.transferRate = tag.m_128451_("transferRate");
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("transferRate", this.transferRate);
        tag.m_128365_("inv", (Tag)this.gpsSlots.serializeNBT());
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        super.m_183515_(tag);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean moved = false;
        BlockPosDim loc = this.getTargetInSlot(0);
        if (loc != null) {
            if (LevelWorldUtil.dimensionIsEqual(loc, this.f_58857_)) {
                this.moveFluids(loc.getSide(), loc.getPos(), this.transferRate, (IFluidHandler)this.tank);
            } else if (((Boolean)ConfigRegistry.TRANSFER_NODES_DIMENSIONAL.get()).booleanValue()) {
                this.moveFluidsDimensional(loc, this.transferRate, (IFluidHandler)this.tank);
            }
        }
        this.setLitProperty(moved);
    }

    BlockPosDim getTargetInSlot(int s) {
        return LocationGpsCard.getPosition(this.gpsSlots.getStackInSlot(s));
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case TRANSFER_RATE: {
                this.transferRate = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
        }
        return 0;
    }

    public float getRed() {
        return 0.89f;
    }

    public float getBlue() {
        return 0.0f;
    }

    public float getGreen() {
        return 0.12f;
    }

    public float getAlpha() {
        return 0.9f;
    }

    public float getThick() {
        return 0.065f;
    }

    static enum Fields {
        RENDER,
        TRANSFER_RATE,
        REDSTONE;

    }
}

