/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.lothrazar.cyclic.block.generatorfluid.RecipeGeneratorFluid;
import com.lothrazar.cyclic.recipe.ingredient.EnergyIngredient;
import com.lothrazar.cyclic.recipe.ingredient.FluidTagIngredient;
import com.lothrazar.cyclic.registry.CyclicRecipeType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.cyclic.generator_fluid")
public class EnergyFluidZen
implements IRecipeManager<RecipeGeneratorFluid> {
    private final Logger logger = LogManager.getLogger();

    public RecipeType<RecipeGeneratorFluid> getRecipeType() {
        return (RecipeType)CyclicRecipeType.GENERATOR_FLUID.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IFluidStack fluid, int rfPertick, int ticks) {
        name = this.fixRecipeName(name);
        RecipeGeneratorFluid m = new RecipeGeneratorFluid(new ResourceLocation("crafttweaker", name), new FluidTagIngredient(new FluidStack(fluid.getFluid(), 1), "", fluid.getAmount()), new EnergyIngredient(rfPertick, ticks));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)m, ""));
        this.logger.debug("Recipe loaded " + m.m_6423_().toString());
    }

    @ZenCodeType.Method
    public void addRecipe(String name, String fluidTag, int amount, int rfPertick, int ticks) {
        name = this.fixRecipeName(name);
        RecipeGeneratorFluid m = new RecipeGeneratorFluid(new ResourceLocation("crafttweaker", name), new FluidTagIngredient(null, fluidTag, amount), new EnergyIngredient(rfPertick, ticks));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)m, ""));
        this.logger.debug("Recipe  (tag %s) loaded " + m.m_6423_().toString(), (Object)fluidTag);
    }

    @ZenCodeType.Method
    public void removeRecipe(String ... names) {
        this.removeByName(names);
        this.logger.debug("Recipe removed " + names);
    }
}

