/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.lothrazar.cyclic.block.solidifier.RecipeSolidifier;
import com.lothrazar.cyclic.recipe.ingredient.EnergyIngredient;
import com.lothrazar.cyclic.recipe.ingredient.FluidTagIngredient;
import com.lothrazar.cyclic.registry.CyclicRecipeType;
import java.util.Arrays;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.cyclic.solidifier")
public class SolidifierZen
implements IRecipeManager<RecipeSolidifier> {
    private final Logger logger = LogManager.getLogger();

    public RecipeType<RecipeSolidifier> getRecipeType() {
        return (RecipeType)CyclicRecipeType.SOLID.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredient[] input, IFluidStack fluid, IItemStack output, int rfPertick, int ticks) {
        name = this.fixRecipeName(name);
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty!");
        }
        NonNullList list = NonNullList.m_122780_((int)input.length, (Object)Ingredient.f_43901_);
        for (int i = 0; i < input.length; ++i) {
            list.set(i, (Object)input[i].asVanillaIngredient());
        }
        RecipeSolidifier recipe = new RecipeSolidifier(new ResourceLocation("crafttweaker", name), (NonNullList<Ingredient>)list, new FluidTagIngredient(new FluidStack(fluid.getFluid(), 1), "", fluid.getAmount()), output.getInternal(), new EnergyIngredient(rfPertick, ticks));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe, ""));
        this.logger.debug("Recipe loaded " + recipe.m_6423_().toString());
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredient[] input, String fluidTag, int fluidQuantity, IItemStack output, int rfPertick, int ticks) {
        name = this.fixRecipeName(name);
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty!");
        }
        NonNullList list = NonNullList.m_122780_((int)input.length, (Object)Ingredient.f_43901_);
        for (int i = 0; i < input.length; ++i) {
            list.set(i, (Object)input[i].asVanillaIngredient());
        }
        fluidTag = fluidTag.replace("<", "").replace(">", "").replace("fluid:", "");
        RecipeSolidifier recipe = new RecipeSolidifier(new ResourceLocation("crafttweaker", name), (NonNullList<Ingredient>)list, new FluidTagIngredient(null, fluidTag, fluidQuantity), output.getInternal(), new EnergyIngredient(rfPertick, ticks));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe, ""));
        this.logger.debug("Recipe (tag %s) loaded " + recipe.m_6423_().toString(), (Object)fluidTag);
    }

    @ZenCodeType.Method
    public void removeRecipe(String ... names) {
        this.removeByName(names);
        this.logger.debug("Recipe removed " + Arrays.toString(names));
    }
}

