/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.fluid;

import com.lothrazar.cyclic.fluid.block.HoneyFluidBlock;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.FluidRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.MaterialRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class FluidHoneyHolder {
    private static final String id = "honey";
    private static final ResourceLocation FLUID_FLOWING = new ResourceLocation("minecraft:block/honey_block_side");
    private static final ResourceLocation FLUID_STILL = new ResourceLocation("minecraft:block/honey_block_top");
    public static final int COLOR = 16764509;
    public static RegistryObject<FlowingFluid> STILL = FluidRegistry.FLUIDS.register("honey", () -> new ForgeFlowingFluid.Source(FluidHoneyHolder.makeProperties()));
    public static RegistryObject<FlowingFluid> FLOWING = FluidRegistry.FLUIDS.register("honey_flowing", () -> new ForgeFlowingFluid.Flowing(FluidHoneyHolder.makeProperties()));
    public static RegistryObject<LiquidBlock> BLOCK = BlockRegistry.BLOCKS.register("honey_block", () -> new HoneyFluidBlock((Supplier<? extends FlowingFluid>)STILL, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_222994_()));
    public static RegistryObject<Item> BUCKET = ItemRegistry.ITEMS.register("honey_bucket", () -> new BucketItem(STILL, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(MaterialRegistry.ITEM_GROUP)));
    public static RegistryObject<FluidType> test_fluid_type = FluidRegistry.FLUID_TYPES.register("honey", () -> new FluidType(FluidType.Properties.create()){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return FLUID_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLUID_FLOWING;
                }

                public ResourceLocation getOverlayTexture() {
                    return null;
                }
            });
        }
    });

    private static ForgeFlowingFluid.Properties makeProperties() {
        return new ForgeFlowingFluid.Properties(test_fluid_type, STILL, FLOWING).bucket(BUCKET).block(BLOCK);
    }
}

