/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TexturedProgress {
    protected final Screen parent;
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected final ResourceLocation texture;
    public int guiLeft;
    public int guiTop;
    public int max = 1;
    protected boolean topDown = true;

    public TexturedProgress(Screen parent, int x, int y, ResourceLocation texture) {
        this(parent, x, y, 14, 14, texture);
    }

    public TexturedProgress(Screen parent, int x, int y, int width, int height, ResourceLocation texture) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.texture = texture;
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x <= mouseX && mouseX <= this.guiLeft + this.x + this.width && this.guiTop + this.y <= mouseY && mouseY <= this.guiTop + this.y + this.height;
    }

    public void draw(PoseStack ms, float current) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        int relX = this.guiLeft + this.x;
        int relY = this.guiTop + this.y;
        if (this.topDown) {
            Screen.m_93133_((PoseStack)ms, (int)relX, (int)relY, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)(this.height * 2));
            int rHeight = this.height - (int)((float)this.height * Math.min(current / (float)this.max, 1.0f));
            Screen.m_93133_((PoseStack)ms, (int)relX, (int)relY, (float)0.0f, (float)this.height, (int)this.width, (int)rHeight, (int)this.width, (int)(this.height * 2));
        } else {
            Screen.m_93133_((PoseStack)ms, (int)relX, (int)relY, (float)0.0f, (float)this.height, (int)this.width, (int)this.height, (int)this.width, (int)(this.height * 2));
            int rWidth = (int)((float)this.width * Math.min(current / (float)this.max, 1.0f));
            if (current != 0.0f) {
                Screen.m_93133_((PoseStack)ms, (int)relX, (int)relY, (float)0.0f, (float)0.0f, (int)(this.width - rWidth), (int)this.height, (int)this.width, (int)(this.height * 2));
            }
        }
    }

    public void renderHoveredToolTip(PoseStack ms, int mouseX, int mouseY, int curr) {
        if (this.isMouseover(mouseX, mouseY) && curr > 0) {
            Object display = "";
            int seconds = curr / 20;
            if (curr > 1200) {
                int minutes = seconds / 60;
                int remainder = seconds % 60;
                display = minutes + "m " + remainder + "s";
            } else {
                display = curr > 100 ? seconds + "s" : curr + "t";
            }
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)display));
            this.parent.m_96597_(ms, list, mouseX, mouseY);
        }
    }

    public void setTopDown(boolean topDown) {
        this.topDown = topDown;
    }
}

