/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.bauble;

import com.lothrazar.cyclic.item.bauble.ItemBaseToggle;
import com.lothrazar.cyclic.util.BlockUtil;
import com.lothrazar.cyclic.util.ItemStackUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class AutoCaveTorchItem
extends ItemBaseToggle {
    private static final int TORCH_LIGHT_LEVEL = 14;
    private static final int TICK_DELAY = 2;
    private static final int BLOCKS_TO_MOVE_FEET_DOWN = 2;
    public static ForgeConfigSpec.IntValue LIGHT_LIMIT;
    public static ForgeConfigSpec.IntValue LIGHT_TARGET;
    public static ForgeConfigSpec.BooleanValue PREFER_WALLS;
    public static ForgeConfigSpec.BooleanValue PREFER_LEFT_WALL;
    private final AtomicInteger timer = new AtomicInteger();
    private final Lock lock = new ReentrantLock();

    public AutoCaveTorchItem(Item.Properties properties) {
        super(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6883_(ItemStack stack, Level world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        if (!this.isOn(stack)) {
            return;
        }
        if (!(entityIn instanceof Player)) {
            return;
        }
        Player player = (Player)entityIn;
        if (player.m_5833_()) {
            return;
        }
        if (stack.m_41773_() >= stack.m_41776_()) {
            stack.m_41721_(stack.m_41776_());
            return;
        }
        if (this.timer.updateAndGet(n -> Math.max(n - 1, 0)) == 0 && this.lock.tryLock()) {
            try {
                this.placeTorchIfNecessary(stack, world, player);
            }
            finally {
                this.lock.unlock();
            }
        }
        this.tryRepairWith(stack, player, Blocks.f_50081_.m_5456_());
    }

    private void placeTorchIfNecessary(ItemStack stack, Level world, Player player) {
        BlockPos next;
        BlockPos playerPos = player.m_20183_();
        if (world.m_8055_(playerPos).m_60815_()) {
            return;
        }
        for (int i = 0; i < 2 && !world.m_8055_(next = playerPos.m_7495_()).m_60815_(); ++i) {
            playerPos = next;
        }
        if (!world.m_8055_(playerPos.m_7495_()).m_60815_()) {
            return;
        }
        int lightLimit = AutoCaveTorchItem.getLightLimit();
        int playerPosLight = world.m_46803_(playerPos);
        world.m_45517_(LightLayer.BLOCK, playerPos);
        if (playerPosLight > lightLimit) {
            return;
        }
        int lightTarget = AutoCaveTorchItem.getLightTarget() + lightLimit - playerPosLight;
        int targetDistance = 14 - lightTarget;
        int fallbackTargetDistance = 14 - (lightLimit + 1);
        assert (targetDistance <= fallbackTargetDistance);
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashMap<BlockPos, Integer> distances = new HashMap<BlockPos, Integer>();
        queue.add(playerPos);
        distances.put(playerPos, 0);
        int playerElevation = playerPos.m_123342_();
        ArrayList<TorchPos> validTorchPositions = this.bfs(world, queue, distances, targetDistance, fallbackTargetDistance, playerElevation);
        boolean preferWalls = AutoCaveTorchItem.isPreferWalls();
        validTorchPositions.sort(Comparator.comparing(torchPos -> preferWalls && torchPos.isNotOnGround() && torchPos.isNotBelowFeet()).thenComparing(torchPos -> -(torchPos.currentLightLevel + (torchPos.isNotBelowFeet() ? 2 : 4) * Math.abs(torchPos.relativeHeight))).thenComparing(torchPos -> -torchPos.playerLightLevel).thenComparing(TorchPos::isNotOnGround).reversed());
        Direction facing = player.m_6350_();
        for (TorchPos torchPos2 : validTorchPositions) {
            if (!BlockUtil.placeTorchSafely(world, torchPos2.pos, torchPos2.getPlacementDirection(facing))) continue;
            ItemStackUtil.damageItem((LivingEntity)player, stack);
            this.timer.set(2);
            return;
        }
        validTorchPositions = this.bfs(world, queue, distances, fallbackTargetDistance, fallbackTargetDistance, playerElevation);
        validTorchPositions.sort(Comparator.comparing(torchPos -> torchPos.playerLightLevel).thenComparing(torchPos -> preferWalls && torchPos.isNotOnGround() && torchPos.isNotBelowFeet()).thenComparing(torchPos -> -(torchPos.currentLightLevel + (torchPos.isNotBelowFeet() ? 2 : 4) * Math.abs(torchPos.relativeHeight))).thenComparing(TorchPos::isNotOnGround).reversed());
        for (TorchPos torchPos2 : validTorchPositions) {
            if (!BlockUtil.placeTorchSafely(world, torchPos2.pos, torchPos2.getPlacementDirection(facing))) continue;
            ItemStackUtil.damageItem((LivingEntity)player, stack);
            this.timer.set(2);
            return;
        }
        this.timer.set(2);
    }

    private ArrayList<TorchPos> bfs(Level world, Queue<BlockPos> queue, HashMap<BlockPos, Integer> distances, int maxPoppedDist, int maxPushedDist, int playerElevation) {
        BlockPos poppedPos;
        int poppedDistance;
        ArrayList<TorchPos> validTorchPositions = new ArrayList<TorchPos>();
        while (!queue.isEmpty() && (poppedDistance = distances.get(poppedPos = queue.peek()).intValue()) <= maxPoppedDist) {
            queue.remove();
            boolean isValidTorch = false;
            boolean wouldUpdateFloatingFallingBlock = false;
            EnumSet<Direction> solidDirections = EnumSet.noneOf(Direction.class);
            for (Direction direction : Direction.values()) {
                BlockPos nextPos = poppedPos.m_121945_(direction);
                BlockState state = world.m_8055_(nextPos);
                if (state.m_60815_()) {
                    solidDirections.add(direction);
                    if (direction != Direction.UP) {
                        isValidTorch = true;
                    }
                } else if (poppedDistance < maxPushedDist && !distances.containsKey(nextPos)) {
                    distances.put(nextPos, poppedDistance + 1);
                    queue.add(nextPos);
                }
                if (direction == Direction.UP || !(state.m_60734_() instanceof FallingBlock) || !FallingBlock.m_53241_((BlockState)world.m_8055_(nextPos.m_7495_()))) continue;
                wouldUpdateFloatingFallingBlock = true;
            }
            if (!isValidTorch || wouldUpdateFloatingFallingBlock || !world.m_46859_(poppedPos)) continue;
            validTorchPositions.add(new TorchPos(poppedPos, poppedPos.m_123342_() - playerElevation, 14 - poppedDistance, world.m_46803_(poppedPos), solidDirections));
        }
        return validTorchPositions;
    }

    private static int getLightLimit() {
        return Math.min((Integer)LIGHT_LIMIT.get(), 13);
    }

    private static int getLightTarget() {
        return Math.min(Math.max(AutoCaveTorchItem.getLightLimit() + 1, (Integer)LIGHT_TARGET.get()), 14);
    }

    private static boolean isPreferWalls() {
        return (Boolean)PREFER_WALLS.get();
    }

    private static boolean isPreferLeftWall() {
        return (Boolean)PREFER_LEFT_WALL.get();
    }

    private static class TorchPos {
        final BlockPos pos;
        final int relativeHeight;
        final int playerLightLevel;
        final int currentLightLevel;
        final EnumSet<Direction> solidDirections;

        public TorchPos(BlockPos pos, int relativeHeight, int playerLightLevel, int currentLightLevel, EnumSet<Direction> solidDirections) {
            assert (!solidDirections.isEmpty());
            this.pos = pos;
            this.relativeHeight = relativeHeight;
            this.playerLightLevel = playerLightLevel;
            this.currentLightLevel = currentLightLevel;
            this.solidDirections = solidDirections;
        }

        public boolean isNotOnGround() {
            return !this.solidDirections.contains(Direction.DOWN);
        }

        public boolean isNotBelowFeet() {
            return this.relativeHeight >= 0;
        }

        public Direction getPlacementDirection(Direction facing) {
            Direction preferredDirection;
            if (this.solidDirections.contains(Direction.DOWN)) {
                return Direction.DOWN;
            }
            Direction direction = preferredDirection = AutoCaveTorchItem.isPreferLeftWall() ? facing.m_122428_() : facing.m_122427_();
            if (this.solidDirections.contains(preferredDirection)) {
                return preferredDirection;
            }
            Direction otherDirection = preferredDirection.m_122424_();
            if (this.solidDirections.contains(otherDirection)) {
                return otherDirection;
            }
            Direction behindPlayer = facing.m_122424_();
            if (this.solidDirections.contains(behindPlayer)) {
                return behindPlayer;
            }
            assert (this.solidDirections.contains(facing));
            return facing;
        }
    }
}

