/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.net.PacketBaseCyclic;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketFluidSync
extends PacketBaseCyclic {
    private BlockPos pos;
    private FluidStack fluid;

    public PacketFluidSync(BlockPos p, FluidStack fluid) {
        this.pos = p;
        this.fluid = fluid;
    }

    public static void handle(PacketFluidSync message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketFluidSync.doWork(message));
        message.done(ctx);
    }

    private static void doWork(PacketFluidSync message) {
        BlockEntity te = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
        if (te instanceof TileBlockEntityCyclic) {
            ((TileBlockEntityCyclic)te).setFluid(message.fluid);
        }
    }

    public static PacketFluidSync decode(FriendlyByteBuf buf) {
        PacketFluidSync msg = new PacketFluidSync(buf.m_130135_(), FluidStack.loadFluidStackFromNBT((CompoundTag)buf.m_130260_()));
        return msg;
    }

    public static void encode(PacketFluidSync msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        CompoundTag tags = new CompoundTag();
        if (msg.fluid != null) {
            msg.fluid.writeToNBT(tags);
        }
        buf.m_130079_(tags);
    }
}

