/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.net.PacketBaseCyclic;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class PacketTileString
extends PacketBaseCyclic {
    private int field;
    private String value;
    private BlockPos pos;

    public PacketTileString(int field, String value, BlockPos pos) {
        this.field = field;
        this.value = value;
        this.pos = pos;
    }

    public PacketTileString() {
    }

    public static void handle(PacketTileString message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level world = player.m_20193_();
            BlockEntity tile = world.m_7702_(message.pos);
            if (tile instanceof TileBlockEntityCyclic) {
                TileBlockEntityCyclic base = (TileBlockEntityCyclic)tile;
                base.setFieldString(message.field, message.value);
                BlockState oldState = world.m_8055_(message.pos);
                world.m_7260_(message.pos, oldState, oldState, 3);
            }
        });
        message.done(ctx);
    }

    public static PacketTileString decode(FriendlyByteBuf buf) {
        PacketTileString p = new PacketTileString();
        p.field = buf.readInt();
        CompoundTag tags = buf.m_130260_();
        p.pos = new BlockPos(tags.m_128451_("x"), tags.m_128451_("y"), tags.m_128451_("z"));
        p.value = buf.m_130136_(Short.MAX_VALUE);
        return p;
    }

    public static void encode(PacketTileString msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.field);
        CompoundTag tags = new CompoundTag();
        tags.m_128405_("x", msg.pos.m_123341_());
        tags.m_128405_("y", msg.pos.m_123342_());
        tags.m_128405_("z", msg.pos.m_123343_());
        buf.m_130079_(tags);
        buf.m_130070_(msg.value);
    }
}

