/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.potion.effect;

import com.lothrazar.cyclic.potion.CyclicMobEffect;
import com.lothrazar.cyclic.util.PlayerUtil;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;

public class FlightMayflyEffect
extends CyclicMobEffect {
    public FlightMayflyEffect(MobEffectCategory typeIn, int liquidColorIn) {
        super(typeIn, liquidColorIn);
    }

    @Override
    public void onPotionAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35936_) {
                PlayerUtil.setMayFlyFromServer(event.getEntity(), true);
            }
        }
    }

    @Override
    public void isPotionApplicable(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_7500_()) {
                event.setResult(Event.Result.DENY);
            }
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @Override
    public void onPotionRemove(MobEffectEvent.Remove event) {
        PlayerUtil.setMayFlyFromServer(event.getEntity(), false);
    }

    @Override
    public void onPotionExpiry(MobEffectEvent.Expired event) {
        PlayerUtil.setMayFlyFromServer(event.getEntity(), false);
    }
}

