/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketTemplateManagerTemplateCreated;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateIO;
import com.direwolf20.buildinggadgets.common.tileentities.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateParseException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateReadException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateWriteException;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class TemplateManagerGUI
extends AbstractContainerScreen<TemplateManagerContainer> {
    private static final ResourceLocation background = new ResourceLocation("buildinggadgets", "textures/gui/template_manager.png");
    private final Rect2i panel = new Rect2i(-12, 12, 136, 80);
    private boolean panelClicked;
    private int clickButton;
    private int clickX;
    private int clickY;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float initPanX;
    private float initPanY;
    private float momentumX;
    private float momentumY;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private EditBox nameField;
    private Button buttonSave;
    private Button buttonLoad;
    private Button buttonCopy;
    private Button buttonPaste;
    private final TemplateManagerTileEntity te;
    private final TemplateManagerContainer container;
    private final LazyOptional<ITemplateProvider> templateProvider = this.getWorld().getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY);
    private Template template;

    public TemplateManagerGUI(TemplateManagerContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, (Component)Component.m_237113_((String)""));
        this.container = container;
        this.te = container.getTe();
    }

    public void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this.f_96547_);
        this.nameField = new EditBox(this.f_96547_, this.f_97735_ - 20 + 8, this.f_97736_ - 5, this.f_97726_ - 16, 9 + 3, (Component)GuiTranslation.TEMPLATE_NAME_TIP.componentTranslation(new Object[0]));
        int x = this.f_97735_ - 20 + 180;
        this.buttonSave = (Button)this.m_142416_((GuiEventListener)new Button(x, this.f_97736_ + 17, 60, 20, (Component)GuiTranslation.BUTTON_SAVE.componentTranslation(new Object[0]), b -> this.onSave()));
        this.buttonLoad = (Button)this.m_142416_((GuiEventListener)new Button(x, this.f_97736_ + 39, 60, 20, (Component)GuiTranslation.BUTTON_LOAD.componentTranslation(new Object[0]), b -> this.onLoad()));
        this.buttonCopy = (Button)this.m_142416_((GuiEventListener)new Button(x, this.f_97736_ + 66, 60, 20, (Component)GuiTranslation.BUTTON_COPY.componentTranslation(new Object[0]), b -> this.onCopy()));
        this.buttonPaste = (Button)this.m_142416_((GuiEventListener)new Button(x, this.f_97736_ + 89, 60, 20, (Component)GuiTranslation.BUTTON_PASTE.componentTranslation(new Object[0]), b -> this.onPaste()));
        this.nameField.m_94199_(50);
        this.nameField.m_94194_(true);
        this.m_142416_((GuiEventListener)this.nameField);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
        this.m_7025_(matrices, mouseX, mouseY);
        TemplateManagerGUI.m_93236_((PoseStack)matrices, (Font)this.f_96547_, (String)"Preview disabled for now...", (int)(this.f_97735_ - 10), (int)(this.f_97736_ + 40), (int)0xFFFFFF);
        if (this.template != null) {
            this.renderRequirement(matrices, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack matrices, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(matrices);
        RenderSystem.m_157456_((int)0, (ResourceLocation)background);
        this.m_93228_(matrices, this.f_97735_ - 20, this.f_97736_ - 12, 0, 0, this.f_97726_, this.f_97727_ + 25);
        this.m_93228_(matrices, this.f_97735_ - 20 + this.f_97726_, this.f_97736_ + 8, this.f_97726_ + 3, 30, 71, this.f_97727_);
        if (!this.buttonCopy.m_198029_() && !this.buttonPaste.m_198029_()) {
            if (this.buttonLoad.m_198029_()) {
                this.m_93228_(matrices, this.f_97735_ + this.f_97726_ - 44, this.f_97736_ + 38, this.f_97726_, 0, 17, 24);
            } else {
                this.m_93228_(matrices, this.f_97735_ + this.f_97726_ - 44, this.f_97736_ + 38, this.f_97726_ + 17, 0, 16, 24);
            }
        }
        this.nameField.m_6305_(matrices, mouseX, mouseY, partialTicks);
        if (this.template != null) {
            this.renderPanel();
        }
    }

    private void validateCache(float partialTicks) {
        if (this.container.m_38853_(0).m_7993_().m_41619_() && this.template != null) {
            this.template = null;
            this.resetViewport();
            return;
        }
        this.container.m_38853_(0).m_7993_().getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            if (this.template == template) {
                return;
            }
            this.template = template;
        }));
    }

    private void renderStructure(IBuildView view, float partialTicks) {
        Random rand = new Random();
        BlockRenderDispatcher dispatcher = this.getMinecraft().m_91289_();
        BufferBuilder bufferBuilder = new BufferBuilder(0x200000);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        for (PlacementTarget target : view) {
            target.placeIn(view.getContext());
            BlockPos targetPos = target.getPos();
            BlockState renderBlockState = view.getContext().getWorld().m_8055_(targetPos);
            BlockEntity te = view.getContext().getWorld().m_7702_(targetPos);
            if (renderBlockState.m_60799_() == RenderShape.MODEL) {
                BakedModel bakedModel = dispatcher.m_110910_(renderBlockState);
            }
            if (te == null) continue;
            try {
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(te);
                if (renderer != null) {
                    // empty if block
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            }
            catch (Exception e) {
                BuildingGadgets.LOG.error("Error rendering TileEntity", (Throwable)e);
            }
        }
        bufferBuilder.m_231175_();
    }

    private void renderRequirement(PoseStack matrices, int mouseX, int mouseY) {
        MaterialList requirements = this.template.getHeaderAndForceMaterials(BuildContext.builder().build((LevelAccessor)this.getWorld())).getRequiredItems();
        if (requirements == null) {
            return;
        }
        Lighting.m_84930_();
        matrices.m_85836_();
        matrices.m_85837_((double)(this.f_97735_ - 30), (double)(this.f_97736_ - 5), 200.0);
        matrices.m_85841_(0.8f, 0.8f, 0.8f);
        String title = "Requirements";
        TemplateManagerGUI.m_93236_((PoseStack)matrices, (Font)this.getMinecraft().f_91062_, (String)title, (int)(5 - this.f_96547_.m_92895_(title)), (int)0, (int)Color.WHITE.getRGB());
        MatchResult list = InventoryHelper.CREATIVE_INDEX.tryMatch(requirements);
        ImmutableMultiset<IUniqueObject<?>> foundItems = list.getFoundItems();
        ImmutableList sortedEntries = ImmutableList.sortedCopyOf(Comparator.comparing(Multiset.Entry::getCount).reversed(), (Iterable)list.getChosenOption().entrySet());
        int index = 0;
        int column = 0;
        for (Multiset.Entry e : sortedEntries) {
            ItemStack stack = ((IUniqueObject)e.getElement()).createStack();
            int x = -20 - column * 25;
            int y = 20 + index * 25;
            this.f_96542_.m_115203_(stack, x + 4, y + 4);
            this.f_96542_.m_115174_(Minecraft.m_91087_().f_91062_, stack, x + 4, y + 4, GadgetUtils.withSuffix(foundItems.count(e.getElement())));
            int space = 20;
            int zoneX = this.f_97735_ - 32 + (-15 - column * space);
            int zoneY = this.f_97736_ - 9 + (20 + index * space);
            if (mouseX > zoneX && mouseX < zoneX + space && mouseY > zoneY && mouseY < zoneY + space) {
                this.m_96617_(matrices, Lists.transform((List)stack.m_41651_((Player)this.getMinecraft().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL), Component::m_7532_), x + 15, y + 25);
            }
            if (++index % 8 != 0) continue;
            ++column;
            index = 0;
        }
        Lighting.m_84931_();
        matrices.m_85849_();
    }

    private void pasteTemplateToStack(Level world, ItemStack stack, Template newTemplate, boolean replaced) {
        world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> this.pasteTemplateToStack((ITemplateProvider)provider, stack, newTemplate, replaced && world.m_5776_()));
    }

    private void pasteTemplateToStack(ITemplateProvider provider, ItemStack stack, Template newTemplate, boolean replaced) {
        stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            provider.setTemplate((ITemplateKey)key, newTemplate);
            if (replaced) {
                PacketHandler.sendToServer(new PacketTemplateManagerTemplateCreated(provider.getId((ITemplateKey)key), this.te.m_58899_()));
            } else {
                provider.requestRemoteUpdate((ITemplateKey)key);
            }
        });
    }

    private boolean replaceStack() {
        ItemStack stack = this.container.m_38853_(1).m_7993_();
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).isPresent()) {
            return false;
        }
        if (stack.m_204117_(TemplateManagerTileEntity.TEMPLATE_CONVERTIBLES)) {
            this.container.m_182406_(1, this.container.m_182424_(), new ItemStack((ItemLike)OurItems.TEMPLATE_ITEM.get()));
            return true;
        }
        return false;
    }

    private void rename(ItemStack stack) {
        if (this.nameField.m_94155_().isEmpty()) {
            return;
        }
        stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            template = template.withName(this.nameField.m_94155_());
            provider.setTemplate((ITemplateKey)key, template);
            provider.requestRemoteUpdate((ITemplateKey)key);
        }));
    }

    private void renderPanel() {
    }

    private void resetViewport() {
        this.rotX = 0.0f;
        this.rotY = 0.0f;
        this.zoom = 1.0f;
        this.momentumX = 0.0f;
        this.momentumY = 0.0f;
        this.panX = 0.0f;
        this.panY = 0.0f;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.panel.m_110087_((int)mouseX - this.f_97735_, (int)mouseY - this.f_97736_)) {
            this.clickButton = mouseButton;
            this.panelClicked = true;
            this.clickX = (int)this.getMinecraft().f_91067_.m_91589_();
            this.clickY = (int)this.getMinecraft().f_91067_.m_91594_();
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        this.panelClicked = false;
        this.initRotX = this.rotX;
        this.initRotY = this.rotY;
        this.initPanX = this.panX;
        this.initPanY = this.panY;
        this.initZoom = this.zoom;
        return super.m_6348_(mouseX, mouseY, state);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.m_7379_();
            return true;
        }
        return this.nameField.m_93696_() ? this.nameField.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                float prevRotX = this.rotX;
                float prevRotY = this.rotY;
                this.rotX = this.initRotX - (float)((int)this.getMinecraft().f_91067_.m_91594_() - this.clickY);
                this.rotY = this.initRotY + (float)((int)this.getMinecraft().f_91067_.m_91589_() - this.clickX);
                this.momentumX = this.rotX - prevRotX;
                this.momentumY = this.rotY - prevRotY;
            } else if (this.clickButton == 1) {
                this.panX = this.initPanX + (float)((int)this.getMinecraft().f_91067_.m_91589_() - this.clickX) / 8.0f;
                this.panY = this.initPanY + (float)((int)this.getMinecraft().f_91067_.m_91594_() - this.clickY) / 8.0f;
            }
        }
        this.rotX += this.momentumX;
        this.rotY += this.momentumY;
        float momentumDampening = 0.98f;
        this.momentumX *= momentumDampening;
        this.momentumY *= momentumDampening;
        if (!this.nameField.m_93696_() && this.nameField.m_94155_().isEmpty()) {
            this.getMinecraft().f_91062_.m_92883_(matrices, GuiTranslation.TEMPLATE_PLACEHOLDER.format(new Object[0]), (float)(this.nameField.f_93620_ - this.f_97735_ + 4), (float)(this.nameField.f_93621_ + 2 - this.f_97736_), -10197916);
        }
        if (this.buttonSave.m_198029_() || this.buttonLoad.m_198029_() || this.buttonPaste.m_198029_()) {
            this.drawSlotOverlay(matrices, this.buttonLoad.m_198029_() ? this.container.m_38853_(0) : this.container.m_38853_(1));
        }
    }

    private void drawSlotOverlay(PoseStack matrices, Slot slot) {
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 1000.0);
        TemplateManagerGUI.m_93172_((PoseStack)matrices, (int)slot.f_40220_, (int)slot.f_40221_, (int)(slot.f_40220_ + 16), (int)(slot.f_40221_ + 16), (int)-1660903937);
        matrices.m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this.zoom = this.initZoom + (float)scrollDelta * 20.0f;
        if (this.zoom < -200.0f) {
            this.zoom = -200.0f;
        }
        if (this.zoom > 5000.0f) {
            this.zoom = 5000.0f;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.nameField.m_94120_();
        if (!this.panelClicked) {
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            this.initPanX = this.panX;
            this.initPanY = this.panY;
        }
    }

    private Level getWorld() {
        return this.getMinecraft().f_91073_;
    }

    public Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    private void runAfterUpdate(int slot, Runnable runnable) {
        this.container.m_38853_(slot).m_7993_().getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
            provider.registerUpdateListener(new ITemplateProvider.IUpdateListener(){
                final /* synthetic */ ITemplateKey val$key;
                final /* synthetic */ Runnable val$runnable;
                {
                    this.val$key = iTemplateKey;
                    this.val$runnable = runnable;
                }

                @Override
                public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey updateKey, Template template) {
                    if (provider.getId(updateKey).equals(provider.getId(this.val$key))) {
                        this.val$runnable.run();
                        provider.removeUpdateListener(this);
                    }
                }
            });
            provider.requestUpdate((ITemplateKey)key);
        }));
    }

    private void onSave() {
        boolean replaced = this.replaceStack();
        ItemStack left = this.container.m_38853_(0).m_7993_();
        ItemStack right = this.container.m_38853_(1).m_7993_();
        if (left.m_41619_()) {
            this.rename(right);
            return;
        }
        this.runAfterUpdate(0, () -> this.templateProvider.ifPresent(provider -> left.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            Template templateToSave = provider.getTemplateForKey((ITemplateKey)key).withName(this.nameField.m_94155_());
            this.pasteTemplateToStack((ITemplateProvider)provider, right, templateToSave, replaced);
        })));
    }

    private void onLoad() {
        boolean replaced = this.replaceStack();
        ItemStack left = this.container.m_38853_(0).m_7993_();
        ItemStack right = this.container.m_38853_(1).m_7993_();
        if (left.m_41619_()) {
            this.rename(right);
            return;
        }
        this.runAfterUpdate(1, () -> this.templateProvider.ifPresent(provider -> right.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            Template templateToSave = provider.getTemplateForKey((ITemplateKey)key);
            this.pasteTemplateToStack((ITemplateProvider)provider, left, templateToSave, replaced);
        })));
    }

    private void onCopy() {
        this.runAfterUpdate(0, () -> {
            ItemStack stack = this.container.m_38853_(0).m_7993_();
            stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
                LocalPlayer player = this.getMinecraft().f_91074_;
                assert (player != null);
                BuildContext buildContext = BuildContext.builder().player((Player)player).stack(stack).build((LevelAccessor)this.getWorld());
                try {
                    Template template = provider.getTemplateForKey((ITemplateKey)key);
                    if (!this.nameField.m_94155_().isEmpty()) {
                        template = template.withName(this.nameField.m_94155_());
                    }
                    String json = TemplateIO.writeTemplateJson(template, buildContext);
                    this.getMinecraft().f_91068_.m_90911_(json);
                    player.m_5661_((Component)MessageTranslation.CLIPBOARD_COPY_SUCCESS.componentTranslation(new Object[0]).m_6270_(Styles.DK_GREEN), false);
                }
                catch (TemplateWriteException.DataCannotBeWrittenException e) {
                    BuildingGadgets.LOG.error("Failed to write Template.", (Throwable)e);
                    player.m_5661_((Component)MessageTranslation.CLIPBOARD_COPY_ERROR_TEMPLATE.componentTranslation(new Object[0]).m_6270_(Styles.RED), false);
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.error("Failed to copy Template to clipboard.", (Throwable)e);
                    player.m_5661_((Component)MessageTranslation.CLIPBOARD_COPY_ERROR.componentTranslation(new Object[0]).m_6270_(Styles.RED), false);
                }
            }));
        });
    }

    private void onPaste() {
        assert (this.getMinecraft().f_91074_ != null);
        String CBString = this.getMinecraft().f_91068_.m_90876_();
        if (GadgetUtils.mightBeLink(CBString)) {
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_FAILED_LINK_COPIED.componentTranslation(new Object[0]).m_6270_(Styles.RED), false);
            return;
        }
        try {
            CompoundTag tagFromJson = TagParser.m_129359_((String)CBString);
            if (!tagFromJson.m_128441_("header")) {
                BuildingGadgets.LOG.error("Attempted to use a 1.12 compound on a newer MC version");
                this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_FAILED_WRONG_MC_VERSION.componentTranslation("(1.12.x)", Minecraft.m_91087_().m_91309_().getVersion().getName()).m_6270_(Styles.RED), false);
                return;
            }
        }
        catch (CommandSyntaxException tagFromJson) {
            // empty catch block
        }
        try {
            Template template = TemplateIO.readTemplateFromJson(CBString);
            Template readTemplate = template.clearMaterials();
            if (!this.nameField.m_94155_().isEmpty()) {
                readTemplate = readTemplate.withName(this.nameField.m_94155_());
            }
            boolean replaced = this.replaceStack();
            ItemStack stack = this.container.m_38853_(1).m_7993_();
            this.pasteTemplateToStack(this.getWorld(), stack, readTemplate, replaced);
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_SUCCESS.componentTranslation(new Object[0]).m_6270_(Styles.DK_GREEN), false);
        }
        catch (TemplateReadException.CorruptJsonException e) {
            BuildingGadgets.LOG.error("Failed to parse json syntax.", (Throwable)e);
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_FAILED_CORRUPT_JSON.componentTranslation(new Object[0]).m_6270_(Styles.RED), false);
        }
        catch (TemplateParseException.IllegalMinecraftVersionException e) {
            BuildingGadgets.LOG.error("Attempted to parse Template for Minecraft version {} but expected between {} and {}.", (Object)e.getMinecraftVersion(), (Object)"1.14.4", (Object)"1.17.1", (Object)e);
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_FAILED_WRONG_MC_VERSION.componentTranslation(e.getMinecraftVersion(), "1.14.4", "1.17.1").m_6270_(Styles.RED), false);
        }
        catch (TemplateParseException.UnknownTemplateVersionException e) {
            BuildingGadgets.LOG.error("Attempted to parse Template version {} but newest is {}.", (Object)e.getTemplateVersion(), (Object)"2.1.0", (Object)e);
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_FAILED_TOO_RECENT_VERSION.componentTranslation(e.getTemplateVersion(), "2.1.0").m_6270_(Styles.RED), false);
        }
        catch (JsonParseException e) {
            BuildingGadgets.LOG.error("Failed to parse Template json.", (Throwable)e);
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_FAILED_INVALID_JSON.componentTranslation(new Object[0]).m_6270_(Styles.RED), false);
        }
        catch (TemplateReadException e) {
            BuildingGadgets.LOG.error("Failed to read Template body.", (Throwable)e);
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_FAILED_CORRUPT_BODY.componentTranslation(new Object[0]).m_6270_(Styles.RED), false);
        }
        catch (Exception e) {
            BuildingGadgets.LOG.error("Failed to paste Template.", (Throwable)e);
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.PASTE_FAILED.componentTranslation(new Object[0]).m_6270_(Styles.RED), false);
        }
    }
}

