/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.CapabilityProviderEnergy;
import com.direwolf20.buildinggadgets.common.capability.IPrivateEnergy;
import com.direwolf20.buildinggadgets.common.capability.provider.MultiCapabilityProvider;
import com.direwolf20.buildinggadgets.common.commands.ForceUnloadedCommand;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.GridMode;
import com.direwolf20.buildinggadgets.common.items.modes.HorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.items.modes.StairMode;
import com.direwolf20.buildinggadgets.common.items.modes.VerticalColumnMode;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.UndoScheduler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.save.SaveManager;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.tainted.save.UndoWorldSave;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractGadget
extends Item {
    private BaseRenderer renderer = (BaseRenderer)DistExecutor.runForDist(this::createRenderFactory, () -> () -> null);
    private final TagKey<Block> whiteList;
    private final TagKey<Block> blackList;
    private Supplier<UndoWorldSave> saveSupplier;

    public AbstractGadget(Item.Properties builder, IntSupplier undoLengthSupplier, String undoName, ResourceLocation whiteListTag, ResourceLocation blackListTag) {
        super(builder.setNoRepair());
        this.whiteList = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)whiteListTag);
        this.blackList = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)blackListTag);
        this.saveSupplier = SaveManager.INSTANCE.registerUndoSave(w -> SaveManager.getUndoSave(w, undoLengthSupplier, undoName));
    }

    public abstract int getEnergyMax();

    public abstract int getEnergyCost(ItemStack var1);

    public TagKey<Block> getWhiteList() {
        return this.whiteList;
    }

    public TagKey<Block> getBlackList() {
        return this.blackList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BaseRenderer getRender() {
        return this.renderer;
    }

    protected abstract Supplier<BaseRenderer> createRenderFactory();

    protected UndoWorldSave getUndoSave() {
        return this.saveSupplier.get();
    }

    protected void addCapabilityProviders(ImmutableList.Builder<ICapabilityProvider> providerBuilder, ItemStack stack, @Nullable CompoundTag tag) {
        providerBuilder.add((Object)new CapabilityProviderEnergy(stack, this::getEnergyMax));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag tag) {
        ImmutableList.Builder providerBuilder = ImmutableList.builder();
        this.addCapabilityProviders((ImmutableList.Builder<ICapabilityProvider>)providerBuilder, stack, tag);
        return new MultiCapabilityProvider((ImmutableList<ICapabilityProvider>)providerBuilder.build());
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (!this.m_220152_(group)) {
            return;
        }
        ItemStack charged = new ItemStack((ItemLike)this);
        charged.m_41784_().m_128347_("energy", (double)this.getEnergyMax());
        items.add((Object)charged);
    }

    public int m_142158_(ItemStack stack) {
        LazyOptional cap = stack.getCapability(ForgeCapabilities.ENERGY);
        if (!cap.isPresent()) {
            return super.m_142158_(stack);
        }
        return cap.map(e -> Math.min(13 * e.getEnergyStored() / e.getMaxEnergyStored(), 13)).orElse(super.m_142158_(stack));
    }

    public int m_142159_(ItemStack stack) {
        LazyOptional cap = stack.getCapability(ForgeCapabilities.ENERGY);
        if (!cap.isPresent()) {
            return super.m_142159_(stack);
        }
        Pair energyStorage = cap.map(e -> Pair.of((Object)e.getEnergyStored(), (Object)e.getMaxEnergyStored())).orElse(Pair.of((Object)0, (Object)0));
        return Mth.m_14169_((float)(Math.max(0.0f, (float)((Integer)energyStorage.getLeft()).intValue() / (float)((Integer)energyStorage.getRight()).intValue()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isDamaged(ItemStack stack) {
        LazyOptional cap = stack.getCapability(ForgeCapabilities.ENERGY);
        if (!cap.isPresent()) {
            return super.isDamaged(stack);
        }
        Pair energyStorage = cap.map(e -> Pair.of((Object)e.getEnergyStored(), (Object)e.getMaxEnergyStored())).orElse(Pair.of((Object)0, (Object)0));
        return energyStorage.getLeft() != energyStorage.getRight();
    }

    public boolean m_142522_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("creative")) {
            return false;
        }
        return stack.getCapability(ForgeCapabilities.ENERGY).map(e -> e.getEnergyStored() != e.getMaxEnergyStored()).orElse(super.m_142522_(stack));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return !toRepair.getCapability(ForgeCapabilities.ENERGY).isPresent() && repair.m_41720_() == Items.f_42415_;
    }

    public boolean isAllowedBlock(BlockState block) {
        if (Lists.newArrayList((Iterable)Registry.f_122824_.m_206058_(this.getWhiteList())).isEmpty()) {
            return !block.m_204336_(this.getBlackList());
        }
        return block.m_204336_(this.getWhiteList());
    }

    public static ItemStack getGadget(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof AbstractGadget) && !((heldItem = player.m_21206_()).m_41720_() instanceof AbstractGadget)) {
            return ItemStack.f_41583_;
        }
        return heldItem;
    }

    public boolean canUse(ItemStack tool, Player player) {
        if (player.m_7500_() || this.getEnergyMax() == 0) {
            return true;
        }
        return this.getEnergyCost(tool) <= tool.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public void applyDamage(ItemStack tool, ServerPlayer player) {
        if (player.m_7500_() || this.getEnergyMax() == 0) {
            return;
        }
        tool.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> ((IPrivateEnergy)e).extractPower(this.getEnergyCost(tool), false));
    }

    protected void addEnergyInformation(List<Component> tooltip, ItemStack stack) {
        if (this.getEnergyMax() == 0) {
            return;
        }
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> tooltip.add((Component)TooltipTranslation.GADGET_ENERGY.componentTranslation(GadgetUtils.withSuffix(energy.getEnergyStored()), GadgetUtils.withSuffix(energy.getMaxEnergyStored())).m_6270_(Styles.GRAY)));
    }

    public final void onRotate(ItemStack stack, Player player) {
        if (this.performRotate(stack, player)) {
            player.m_5661_((Component)MessageTranslation.ROTATED.componentTranslation(new Object[0]).m_6270_(Styles.AQUA), true);
        }
    }

    protected boolean performRotate(ItemStack stack, Player player) {
        return false;
    }

    public final void onMirror(ItemStack stack, Player player) {
        if (this.performMirror(stack, player)) {
            player.m_5661_((Component)MessageTranslation.MIRRORED.componentTranslation(new Object[0]).m_6270_(Styles.AQUA), true);
        }
    }

    protected boolean performMirror(ItemStack stack, Player player) {
        return false;
    }

    public final void onAnchor(ItemStack stack, Player player) {
        if (this.getAnchor(stack) == null) {
            BlockHitResult lookingAt = VectorHelper.getLookingAt(player, stack);
            if (player.f_19853_.m_46859_(lookingAt.m_82425_())) {
                return;
            }
            this.onAnchorSet(stack, player, lookingAt);
            player.m_5661_((Component)MessageTranslation.ANCHOR_SET.componentTranslation(new Object[0]).m_6270_(Styles.AQUA), true);
        } else {
            this.onAnchorRemoved(stack, player);
            player.m_5661_((Component)MessageTranslation.ANCHOR_REMOVED.componentTranslation(new Object[0]).m_6270_(Styles.AQUA), true);
        }
    }

    protected void onAnchorSet(ItemStack stack, Player player, BlockHitResult lookingAt) {
        GadgetUtils.writePOSToNBT(stack, lookingAt.m_82425_(), "anchor");
    }

    protected void onAnchorRemoved(ItemStack stack, Player player) {
        stack.m_41784_().m_128473_("anchor");
    }

    @Nullable
    public BlockPos getAnchor(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    public static boolean getFuzzy(ItemStack stack) {
        return stack.m_41784_().m_128471_("fuzzy");
    }

    public static void toggleFuzzy(Player player, ItemStack stack) {
        stack.m_41784_().m_128379_("fuzzy", !AbstractGadget.getFuzzy(stack));
        player.m_5661_((Component)MessageTranslation.FUZZY_MODE.componentTranslation(AbstractGadget.getFuzzy(stack)).m_6270_(Styles.AQUA), true);
    }

    public static boolean getConnectedArea(ItemStack stack) {
        return !stack.m_41784_().m_128471_("unconnected_area");
    }

    public static void toggleConnectedArea(Player player, ItemStack stack) {
        stack.m_41784_().m_128379_("unconnected_area", AbstractGadget.getConnectedArea(stack));
        player.m_5661_((Component)(stack.m_41720_() instanceof GadgetDestruction ? MessageTranslation.CONNECTED_AREA : MessageTranslation.CONNECTED_SURFACE).componentTranslation(AbstractGadget.getConnectedArea(stack)).m_6270_(Styles.AQUA), true);
    }

    public static boolean shouldRayTraceFluid(ItemStack stack) {
        return stack.m_41784_().m_128471_("raytrace_fluid");
    }

    public static void toggleRayTraceFluid(ServerPlayer player, ItemStack stack) {
        stack.m_41784_().m_128379_("raytrace_fluid", !AbstractGadget.shouldRayTraceFluid(stack));
        player.m_5661_((Component)MessageTranslation.RAYTRACE_FLUID.componentTranslation(AbstractGadget.shouldRayTraceFluid(stack)).m_6270_(Styles.AQUA), true);
    }

    public static void addInformationRayTraceFluid(List<Component> tooltip, ItemStack stack) {
        tooltip.add((Component)TooltipTranslation.GADGET_RAYTRACE_FLUID.componentTranslation(String.valueOf(AbstractGadget.shouldRayTraceFluid(stack))).m_6270_(Styles.BLUE));
    }

    public UUID getUUID(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128403_("uuid")) {
            UUID newId = this.getUndoSave().getFreeUUID();
            nbt.m_128362_("uuid", newId);
            return newId;
        }
        return nbt.m_128342_("uuid");
    }

    public static int getRangeInBlocks(int range, AbstractMode mode) {
        if (mode instanceof StairMode || mode instanceof VerticalColumnMode || mode instanceof HorizontalColumnMode) {
            return range;
        }
        if (mode instanceof GridMode) {
            return range < 7 ? 9 : (range < 13 ? 121 : 361);
        }
        return range == 1 ? 1 : (range + 1) * (range + 1);
    }

    protected void pushUndo(ItemStack stack, Undo undo) {
        if (undo.getUndoData().isEmpty()) {
            return;
        }
        UndoWorldSave save = this.getUndoSave();
        save.insertUndo(this.getUUID(stack), undo);
    }

    public void undo(Level world, Player player, ItemStack stack) {
        UndoWorldSave save = this.getUndoSave();
        Optional<Undo> undoOptional = save.getUndo(this.getUUID(stack));
        if (undoOptional.isPresent()) {
            ImmutableSortedSet<ChunkPos> unloadedChunks;
            Undo undo = undoOptional.get();
            IItemIndex index = InventoryHelper.index(stack, player);
            if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloadedChunks = undo.getBoundingBox().getUnloadedChunks((LevelReader)world)).isEmpty()) {
                this.pushUndo(stack, undo);
                player.m_5661_((Component)MessageTranslation.UNDO_UNLOADED.componentTranslation(new Object[0]).m_6270_(Styles.RED), true);
                BuildingGadgets.LOG.error("Player attempted to undo a Region missing {} unloaded chunks. Denied undo!", (Object)unloadedChunks.size());
                BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", unloadedChunks);
                return;
            }
            BuildContext buildContext = BuildContext.builder().player(player).stack(stack).build((LevelAccessor)world);
            UndoScheduler.scheduleUndo(undo, index, buildContext, (Integer)Config.GADGETS.placeSteps.get());
        } else {
            player.m_5661_((Component)MessageTranslation.NOTHING_TO_UNDO.componentTranslation(new Object[0]).m_6270_(Styles.RED), true);
        }
    }
}

