/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

final class UndoHistory {
    private final Deque<Undo> history;
    private final IntSupplier maxLengthSupplier;

    UndoHistory(IntSupplier maxLengthSupplier) {
        this.maxLengthSupplier = Objects.requireNonNull(maxLengthSupplier);
        this.history = new LinkedList<Undo>();
    }

    UndoHistory add(Undo undo) {
        this.history.addFirst(undo);
        this.ensureSize();
        return this;
    }

    Optional<Undo> get() {
        this.ensureSize();
        return Optional.ofNullable(this.history.pollFirst());
    }

    Optional<Undo> peek() {
        this.ensureSize();
        return Optional.ofNullable(this.history.peekFirst());
    }

    void read(CompoundTag nbt) {
        this.history.clear();
        Tag list = nbt.m_128423_("undo_history");
        if (list instanceof ListTag) {
            NBTHelper.deserializeCollection((ListTag)list, this.history, inbt -> Undo.deserialize((CompoundTag)inbt));
            this.ensureSize();
        }
    }

    public void write(CompoundTag nbt) {
        nbt.m_128365_("undo_history", (Tag)NBTHelper.writeIterable(this.history, Undo::serialize));
    }

    private void ensureSize() {
        int maxLength = this.maxLengthSupplier.getAsInt();
        Preconditions.checkArgument((maxLength >= 0 ? 1 : 0) != 0, (Object)"Cannot have a negative max History Length!!!");
        while (this.history.size() > maxLength) {
            this.history.pollLast();
        }
    }
}

