/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.data.HeightUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import net.minecraft.Util;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class ChunkUpdateTask
implements MapTask,
BiomeManager.NoiseBiomeSource {
    public static final int[] ALL_BLOCKS = (int[])Util.m_137469_((Object)new int[256], array -> {
        for (int i = 0; i < 256; ++i) {
            array[i] = i;
        }
    });
    private static final ResourceLocation AIR = new ResourceLocation("minecraft:air");
    public static long debugLastTime = 0L;
    public MapManager manager;
    public final Level level;
    public final ChunkAccess chunkAccess;
    public final ChunkPos pos;
    public final long biomeZoomSeed;
    public final int[] blocksToUpdate;
    private final long taskStartTime;

    public ChunkUpdateTask(@Nullable MapManager m, Level w, ChunkAccess ca, ChunkPos p, long zs, int[] s) {
        this.manager = m;
        this.level = w;
        this.chunkAccess = ca;
        this.pos = p;
        this.biomeZoomSeed = zs;
        this.blocksToUpdate = s;
        this.taskStartTime = System.currentTimeMillis();
    }

    @Override
    public void runMapTask() throws Exception {
        boolean versionChange;
        while (this.manager == null) {
            this.manager = MapManager.inst;
            if (this.manager != null) continue;
            if (System.currentTimeMillis() - this.taskStartTime >= 30000L) {
                return;
            }
            Thread.sleep(1L);
        }
        if (this.manager.invalid) {
            return;
        }
        long startTime = System.nanoTime();
        ResourceKey dimId = this.level.m_46472_();
        MapChunk mapChunk = this.manager.getDimension((ResourceKey<Level>)dimId).getRegion(XZ.regionFromChunk((ChunkPos)this.pos)).getDataBlocking().getChunk(XZ.of((ChunkPos)this.pos));
        MapRegionData data = mapChunk.region.getDataBlocking();
        Registry biomes = this.level.m_5962_().m_175515_(Registry.f_122885_);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int blockX = this.pos.m_45604_();
        int blockZ = this.pos.m_45605_();
        boolean changed = false;
        boolean bl = versionChange = mapChunk.version != 4;
        if (versionChange) {
            mapChunk.version = 4;
            changed = true;
        }
        for (int wi : this.blocksToUpdate) {
            int wx = wi % 16;
            int wz = wi / 16;
            blockPos.m_122178_(blockX + wx, this.chunkAccess.m_5885_(Heightmap.Types.MOTION_BLOCKING, blockX + wx, blockZ + wz) + 2, blockZ + wz);
            int waterY = Mth.m_14045_((int)HeightUtils.getHeight(this.level, this.chunkAccess, blockPos), (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
            int height = blockPos.m_123342_();
            BlockState state = this.chunkAccess.m_8055_((BlockPos)blockPos);
            int ax = mapChunk.pos.x * 16 + wx;
            int az = mapChunk.pos.z * 16 + wz;
            int index = ax + az * 512;
            int waterLightAndBiome0 = data.waterLightAndBiome[index] & 0xFFFF;
            int blockIndex0 = data.getBlockIndex(index);
            short height0 = data.height[index];
            blockPos.m_142448_(waterY == -32767 ? height : waterY);
            int waterLightAndBiome = waterLightAndBiome0 & 0x7FF;
            waterLightAndBiome |= waterY != -32767 ? 32768 : 0;
            waterLightAndBiome |= (this.level.m_45517_(LightLayer.BLOCK, (BlockPos)blockPos) & 0xF) << 11;
            ResourceLocation id = state == null ? AIR : FTBChunks.BLOCK_REGISTRY.getId((Object)state.m_60734_());
            int blockIndex = this.manager.getBlockColorIndex(id == null ? AIR : id);
            Biome biome = (Biome)this.m_203495_(blockPos.m_123341_() >> 2, blockPos.m_123342_() >> 2, blockPos.m_123343_() >> 2).m_203334_();
            waterLightAndBiome &= 0xF800;
            waterLightAndBiome |= this.manager.getBiomeColorIndex((Registry<Biome>)biomes, biome, biome) & 0x7FF;
            if (versionChange || height0 != height) {
                data.height[index] = (short)height;
                changed = true;
            }
            if (versionChange || waterLightAndBiome0 != waterLightAndBiome) {
                data.waterLightAndBiome[index] = (short)waterLightAndBiome;
                if (biome != null && (versionChange || (waterLightAndBiome0 & 0x7FF) != (waterLightAndBiome & 0x7FF))) {
                    double cx = blockPos.m_123341_();
                    double cz = blockPos.m_123343_();
                    data.foliage[index] = data.foliage[index] & 0xFF000000 | BiomeColors.f_108790_.m_130045_(biome, cx, cz) & 0xFFFFFF;
                    data.grass[index] = data.grass[index] & 0xFF000000 | BiomeColors.f_108789_.m_130045_(biome, cx, cz) & 0xFFFFFF;
                    data.water[index] = data.water[index] & 0xFF000000 | BiomeColors.f_108791_.m_130045_(biome, cx, cz) & 0xFFFFFF;
                }
                changed = true;
            }
            if (!versionChange && blockIndex0 == blockIndex) continue;
            data.setBlockIndex(index, blockIndex);
            changed = true;
        }
        if (changed) {
            mapChunk.modified = System.currentTimeMillis();
            mapChunk.region.update(true);
        }
        debugLastTime = System.nanoTime() - startTime;
    }

    public String toString() {
        return "ChunkUpdateTask@" + this.pos;
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        if (x >> 2 == this.pos.f_45578_ && z >> 2 == this.pos.f_45579_) {
            return this.chunkAccess.m_203495_(x, y, z);
        }
        return this.level.m_203495_(x, y, z);
    }
}

