/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.mcwrapper.BlockWrapper;
import chanceCubes.util.Location2I;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MazeGenerator {
    private int width;
    private int height;
    private int[][] map;
    private final ArrayList<Location2I> walls = new ArrayList();
    private final RewardBlockCache cache;
    private final int nonWall = 0;
    private final BlockPos startPos;
    private Location2I endBlock;
    public BlockPos endBlockWorldCords;

    public MazeGenerator(Level level, BlockPos pos, BlockPos playerPos) {
        this.cache = new RewardBlockCache(level, pos, playerPos);
        this.startPos = pos;
    }

    public void generate(Level level, int width, int height) {
        this.width = width;
        this.height = height;
        this.map = new int[width][height];
        int wall = 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.map[x][y] = wall;
            }
        }
        this.map[1][1] = 0;
        this.walls.add(new Location2I(1, 1));
        Location2I current = new Location2I(0, 0);
        do {
            int randomLoc = RewardsUtil.rand.nextInt(this.walls.size());
            int currentX = this.walls.get(randomLoc).getX();
            int currentY = this.walls.get(randomLoc).getY();
            current.setXY(currentX, currentY);
            Location2I north = current.add(0, -1);
            Location2I east = current.add(1, 0);
            Location2I south = current.add(0, 1);
            Location2I west = current.add(-1, 0);
            if (!this.checkwalls(current)) {
                this.map[currentX][currentY] = 0;
                this.walls.remove(randomLoc);
                if (north.getY() > 0 && this.map[north.getX()][north.getY()] == wall && this.map[north.getX()][north.getY() - 1] == wall && !this.walls.contains(north)) {
                    this.walls.add(north);
                }
                if (east.getX() + 1 < width && this.map[east.getX()][east.getY()] == wall && this.map[east.getX() + 1][east.getY()] == wall && !this.walls.contains(east)) {
                    this.walls.add(east);
                }
                if (south.getY() + 1 < height && this.map[south.getX()][south.getY()] == wall && this.map[south.getX()][south.getY() + 1] == wall && !this.walls.contains(south)) {
                    this.walls.add(south);
                }
                if (west.getX() <= 0 || this.map[west.getX()][west.getY()] != wall || this.map[west.getX() - 1][west.getY()] != wall || this.walls.contains(west)) continue;
                this.walls.add(west);
                continue;
            }
            this.walls.remove(randomLoc);
        } while (this.walls.size() > 0);
        int endBlockX = width - 1;
        int endBlockZ = height - 1;
        boolean run = true;
        int i = 0;
        while (run) {
            for (int xx = 0; xx <= i; ++xx) {
                for (int zz = i; zz >= 0; --zz) {
                    if (this.map[endBlockX - xx][endBlockZ - zz] != this.nonWall || !run) continue;
                    this.endBlock = new Location2I(endBlockX - xx, endBlockZ - zz);
                    run = false;
                }
            }
            ++i;
        }
        this.placeBlocks(level);
    }

    private boolean checkwalls(Location2I loc) {
        Location2I north = loc.add(0, -1);
        Location2I east = loc.add(1, 0);
        Location2I south = loc.add(0, 1);
        Location2I west = loc.add(-1, 0);
        int yes = 0;
        if (north.getY() >= 0 && this.map[north.getX()][north.getY()] == 0) {
            ++yes;
        }
        if (east.getX() < this.width && this.map[east.getX()][east.getY()] == 0) {
            ++yes;
        }
        if (south.getY() < this.height && this.map[south.getX()][south.getY()] == 0) {
            ++yes;
        }
        if (west.getX() >= 0 && this.map[west.getX()][west.getY()] == 0) {
            ++yes;
        }
        return yes > 1;
    }

    private void placeBlocks(Level level) {
        int xoff = -(this.width / 2);
        int zoff = -(this.height / 2);
        for (int xx = 0; xx < this.width; ++xx) {
            for (int zz = 0; zz < this.height; ++zz) {
                if (this.map[xx][zz] == 0) {
                    this.cache.cacheBlock(new BlockPos(xoff + xx, -1, zoff + zz), Blocks.f_50752_.m_49966_());
                    this.cache.cacheBlock(new BlockPos(xoff + xx, 0, zoff + zz), Blocks.f_50081_.m_49966_());
                    this.cache.cacheBlock(new BlockPos(xoff + xx, 1, zoff + zz), Blocks.f_50016_.m_49966_());
                    this.cache.cacheBlock(new BlockPos(xoff + xx, 2, zoff + zz), Blocks.f_50752_.m_49966_());
                    continue;
                }
                this.cache.cacheBlock(new BlockPos(xoff + xx, -1, zoff + zz), Blocks.f_50016_.m_49966_());
                this.cache.cacheBlock(new BlockPos(xoff + xx, 0, zoff + zz), Blocks.f_50752_.m_49966_());
                this.cache.cacheBlock(new BlockPos(xoff + xx, 1, zoff + zz), Blocks.f_50752_.m_49966_());
                this.cache.cacheBlock(new BlockPos(xoff + xx, 2, zoff + zz), Blocks.f_50016_.m_49966_());
            }
        }
        this.endBlockWorldCords = new BlockPos(this.startPos.m_123341_() + xoff + this.endBlock.getX(), this.startPos.m_123342_(), this.startPos.m_123343_() + zoff + this.endBlock.getY());
        this.cache.cacheBlock(new BlockPos(xoff + this.endBlock.getX(), 0, zoff + this.endBlock.getY()), (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(7)));
        BlockEntity be = level.m_7702_(new BlockPos(this.startPos.m_123341_() + xoff + this.endBlock.getX(), this.startPos.m_123342_(), this.startPos.m_123343_() + zoff + this.endBlock.getY()));
        BlockWrapper.setSignText(be, new String[]{"Break me", "To beat the", "Maze"});
    }

    public void endMaze(Player player) {
        this.cache.restoreBlocks((Entity)player);
    }
}

