/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.auudio.audio;

import de.keksuccino.auudio.audio.AudioClip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AudioHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"auudio/AudioHandler");
    private static List<AudioClip> clips = new ArrayList<AudioClip>();
    private static List<AudioClip> wasPlayingLastTick = new ArrayList<AudioClip>();
    public static List<Runnable> postReloadingTasks = new ArrayList<Runnable>();
    private static boolean reloaded = false;
    protected static Overlay lastOverlay = null;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new AudioHandler());
        LOGGER.info("Initialized!");
    }

    public static void registerAudioClip(AudioClip clip) {
        if (!clips.contains(clip)) {
            clips.add(clip);
        }
    }

    public static void unregisterAudioClip(AudioClip clip) {
        if (clips.contains(clip)) {
            clip.destroy();
        }
    }

    public static void updateVolumes() {
        Minecraft.m_91087_().m_91106_().m_120358_(SoundSource.MASTER, Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER));
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        for (AudioClip c : clips) {
            if (c.isLooping() && wasPlayingLastTick.contains(c) && !c.playing() && c.channel != null && !c.paused()) {
                c.stop();
                c.play();
            }
            if (!c.playing()) {
                wasPlayingLastTick.remove(c);
                continue;
            }
            if (wasPlayingLastTick.contains(c)) continue;
            wasPlayingLastTick.add(c);
        }
        if (lastOverlay != null && Minecraft.m_91087_().m_91265_() == null) {
            LOGGER.info("Reloading sounds!");
            for (AudioClip c : clips) {
                c.prepare();
            }
            reloaded = true;
        } else if (reloaded) {
            LOGGER.info("Running post-reload tasks..");
            for (Runnable r : postReloadingTasks) {
                r.run();
            }
            reloaded = false;
        }
        lastOverlay = Minecraft.m_91087_().m_91265_();
    }
}

