/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.handler;

import com.blakebr0.ironjetpacks.client.helper.HudHelper;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class HudHandler {
    private static final ResourceLocation HUD_TEXTURE = new ResourceLocation("ironjetpacks", "textures/gui/hud.png");
    private static final IGuiOverlay HUD_OVERLAY = (gui, matrix, partialTick, width, height) -> {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && HudHandler.isVisible(mc)) {
            HudHelper.HudPos pos;
            ItemStack chest = JetpackUtils.getEquippedJetpack((Player)mc.f_91074_);
            Item item = chest.m_41720_();
            if (!chest.m_41619_() && item instanceof JetpackItem && (pos = HudHelper.getHudPos()) != null) {
                int xPos = (int)((double)pos.x / 0.33) - 18;
                int yPos = (int)((double)pos.y / 0.33) - 78;
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_TEXTURE);
                matrix.m_85836_();
                matrix.m_85841_(0.33f, 0.33f, 1.0f);
                Screen.m_93133_((PoseStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)28, (int)156, (int)256, (int)256);
                int i2 = HudHelper.getEnergyBarScaled(chest);
                Screen.m_93133_((PoseStack)matrix, (int)xPos, (int)(166 - i2 + yPos - 10), (float)28.0f, (float)(156 - i2), (int)28, (int)i2, (int)256, (int)256);
                matrix.m_85849_();
                String fuel = "\u00a77" + HudHelper.getFuelString(chest);
                String throttle = "\u00a77T: " + (int)(JetpackUtils.getThrottle(chest) * 100.0) + "%";
                String engine = "\u00a77E: " + HudHelper.getStatusString(JetpackUtils.isEngineOn(chest));
                String hover = "\u00a77H: " + HudHelper.getStatusString(JetpackUtils.isHovering(chest));
                if (pos.side == 1) {
                    mc.f_91062_.m_92750_(matrix, fuel, (float)(pos.x - 8 - mc.f_91062_.m_92895_(fuel)), (float)(pos.y - 21), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, fuel, (float)(pos.x - 8 - mc.f_91062_.m_92895_(throttle)), (float)(pos.y - 6), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, engine, (float)(pos.x - 8 - mc.f_91062_.m_92895_(engine)), (float)(pos.y + 4), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, hover, (float)(pos.x - 8 - mc.f_91062_.m_92895_(hover)), (float)(pos.y + 14), 0xF9FFFE);
                } else {
                    mc.f_91062_.m_92750_(matrix, fuel, (float)(pos.x + 6), (float)(pos.y - 21), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, throttle, (float)(pos.x + 6), (float)(pos.y - 6), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, engine, (float)(pos.x + 6), (float)(pos.y + 4), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, hover, (float)(pos.x + 6), (float)(pos.y + 14), 0xF9FFFE);
                }
            }
        }
    };

    @SubscribeEvent
    public void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "jetpack_hud", HUD_OVERLAY);
    }

    private static boolean isVisible(Minecraft mc) {
        return (Boolean)ModConfigs.ENABLE_HUD.get() != false && ((Boolean)ModConfigs.SHOW_HUD_OVER_CHAT.get() != false || (Boolean)ModConfigs.SHOW_HUD_OVER_CHAT.get() == false && !(mc.f_91080_ instanceof ChatScreen)) && !mc.f_91066_.f_92062_ && !mc.f_91066_.f_92063_;
    }
}

