/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import elucent.rootsclassic.compat.jei.JEIPlugin;
import elucent.rootsclassic.compat.jei.wrapper.RitualWrapper;
import elucent.rootsclassic.registry.RootsRegistry;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class RitualCategory
implements IRecipeCategory<RitualWrapper> {
    private static final ResourceLocation backgroundLocation = new ResourceLocation("rootsclassic", "textures/gui/jei/compat.png");
    private static final ResourceLocation location = new ResourceLocation("rootsclassic", "textures/gui/tabletaltar.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic ingredientBackground;
    private final IDrawableStatic incenseBackground;
    private final IDrawableStatic resultBackground;
    private final IDrawableStatic grid;
    private final IDrawableStatic stone;
    private final IDrawableStatic mundaneStone;
    private final IDrawableStatic attunedStone;
    private final Component localizedName;

    public RitualCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(backgroundLocation, 0, 0, 94, 100).addPadding(0, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RootsRegistry.ALTAR.get()));
        this.ingredientBackground = guiHelper.createDrawable(location, 61, 53, 70, 22);
        this.resultBackground = guiHelper.createDrawable(location, 61, 53, 22, 22);
        this.incenseBackground = guiHelper.createDrawable(location, 49, 85, 94, 22);
        this.grid = guiHelper.createDrawable(location, 50, 118, 93, 93);
        this.stone = guiHelper.createDrawable(location, 192, 32, 16, 16);
        this.mundaneStone = guiHelper.createDrawable(location, 192, 48, 16, 16);
        this.attunedStone = guiHelper.createDrawable(location, 192, 64, 16, 16);
        this.localizedName = Component.m_237115_((String)"rootsclassic.gui.jei.category.ritual");
    }

    public RecipeType<RitualWrapper> getRecipeType() {
        return JEIPlugin.RITUAL_TYPE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualWrapper recipe, IFocusGroup focuses) {
        ItemStack stack;
        int i;
        for (i = 0; i < recipe.getIngredients().size(); ++i) {
            stack = recipe.getIngredients().get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, 15 + i * 24, 3).addItemStack(stack);
        }
        for (i = 0; i < recipe.getIncenses().size(); ++i) {
            stack = recipe.getIncenses().get(i);
            builder.addSlot(RecipeIngredientRole.CATALYST, 28 + i * 16, 27).addItemStack(stack);
        }
        if (!recipe.getResult().m_41619_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 67).addItemStack(recipe.getResult());
        }
    }

    public void draw(RitualWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
        this.ingredientBackground.draw(stack, 12, 0);
        this.incenseBackground.draw(stack, 0, 24);
        this.resultBackground.draw(stack, 64, 64);
        stack.m_85836_();
        stack.m_85841_(0.5f, 0.5f, 1.0f);
        this.grid.draw(stack, 20, 100);
        int basePosX = 63;
        int basePosY = 135;
        List<Block> blocks = recipe.getBlocks();
        List<BlockPos> relativePosition = recipe.getPositionsRelative();
        for (int i = 0; i < blocks.size(); ++i) {
            int xShift = 0;
            int yShift = 0;
            this.stone.draw(stack, basePosX, basePosY);
            if (blocks.get(i).equals(RootsRegistry.MUNDANE_STANDING_STONE.get())) {
                xShift = 8 * relativePosition.get(i).m_123341_();
                yShift = 8 * relativePosition.get(i).m_123343_();
                this.mundaneStone.draw(stack, basePosX + xShift, basePosY + yShift);
            }
            if (!blocks.get(i).equals(RootsRegistry.ATTUNED_STANDING_STONE.get())) continue;
            xShift = 8 * relativePosition.get(i).m_123341_();
            yShift = 8 * relativePosition.get(i).m_123343_();
            this.attunedStone.draw(stack, basePosX + xShift, basePosY + yShift);
        }
        stack.m_85849_();
    }
}

