/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.api.event;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.Event;
import vazkii.quark.api.IAdvancementModifier;
import vazkii.quark.api.IAdvancementModifierDelegate;

public class GatherAdvancementModifiersEvent
extends Event
implements IAdvancementModifierDelegate {
    private final IAdvancementModifierDelegate delegate;
    private final Set<IAdvancementModifier> modifiers = new HashSet<IAdvancementModifier>();

    public GatherAdvancementModifiersEvent(IAdvancementModifierDelegate delegate) {
        this.delegate = delegate;
    }

    public void register(IAdvancementModifier modifier) {
        this.modifiers.add(modifier);
    }

    public Set<IAdvancementModifier> modifiers() {
        return this.modifiers;
    }

    @Override
    public IAdvancementModifier createAdventuringTimeMod(Set<ResourceKey<Biome>> locations) {
        return this.delegate.createAdventuringTimeMod(locations);
    }

    @Override
    public IAdvancementModifier createBalancedDietMod(Set<ItemLike> items) {
        return this.delegate.createBalancedDietMod(items);
    }

    @Override
    public IAdvancementModifier createFuriousCocktailMod(BooleanSupplier isPotion, Set<MobEffect> effects) {
        return this.delegate.createFuriousCocktailMod(isPotion, effects);
    }

    @Override
    public IAdvancementModifier createMonsterHunterMod(Set<EntityType<?>> types) {
        return this.delegate.createMonsterHunterMod(types);
    }

    @Override
    public IAdvancementModifier createTwoByTwoMod(Set<EntityType<?>> types) {
        return this.delegate.createTwoByTwoMod(types);
    }

    @Override
    public IAdvancementModifier createWaxOnWaxOffMod(Set<Block> unwaxed, Set<Block> waxed) {
        return this.delegate.createWaxOnWaxOffMod(unwaxed, waxed);
    }

    @Override
    public IAdvancementModifier createFishyBusinessMod(Set<ItemLike> fishes) {
        return this.delegate.createFishyBusinessMod(fishes);
    }

    @Override
    public IAdvancementModifier createTacticalFishingMod(Set<BucketItem> buckets) {
        return this.delegate.createTacticalFishingMod(buckets);
    }

    @Override
    public IAdvancementModifier createASeedyPlaceMod(Set<Block> seeds) {
        return this.delegate.createASeedyPlaceMod(seeds);
    }

    @Override
    public IAdvancementModifier createGlowAndBeholdMod(Set<Block> blocks) {
        return this.delegate.createGlowAndBeholdMod(blocks);
    }
}

