/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler.advancement.mod;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemInteractWithBlockTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import vazkii.quark.api.IMutableAdvancement;
import vazkii.quark.base.handler.advancement.AdvancementModifier;
import vazkii.quark.base.module.QuarkModule;

public class WaxModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET_ON = new ResourceLocation("husbandry/wax_on");
    private static final ResourceLocation TARGET_OFF = new ResourceLocation("husbandry/wax_off");
    private final Set<Block> unwaxed;
    private final Set<Block> waxed;

    public WaxModifier(QuarkModule module, Set<Block> unwaxed, Set<Block> waxed) {
        super(module);
        this.unwaxed = unwaxed;
        this.waxed = waxed;
        Preconditions.checkArgument((!unwaxed.isEmpty() || !waxed.isEmpty() ? 1 : 0) != 0, (Object)"Advancement modifier list cant be empty");
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET_ON, (Object)TARGET_OFF);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv) {
        CriterionTriggerInstance criterionTriggerInstance;
        String title = res.m_135815_().replaceAll(".+/", "");
        Criterion criterion = adv.getCriterion(title);
        if (criterion != null && (criterionTriggerInstance = criterion.m_11416_()) instanceof ItemInteractWithBlockTrigger.TriggerInstance) {
            ItemInteractWithBlockTrigger.TriggerInstance iib = (ItemInteractWithBlockTrigger.TriggerInstance)criterionTriggerInstance;
            HashSet<Block> blockSet = iib.f_220058_.f_52602_.f_146710_;
            if (blockSet != null) {
                Set<Block> ourSet;
                Set<Block> set = ourSet = res.equals((Object)TARGET_ON) ? this.unwaxed : this.waxed;
                if (!WaxModifier.addToBlockSet((Set<Block>)blockSet, ourSet)) {
                    iib.f_220058_.f_52602_.f_146710_ = blockSet = new HashSet<Block>(blockSet);
                    WaxModifier.addToBlockSet(blockSet, ourSet);
                }
            }
        }
        return true;
    }

    private static boolean addToBlockSet(Set<Block> blockSet, Set<Block> ourSet) {
        try {
            blockSet.addAll(ourSet);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

