/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.content.building.module.GlassItemFrameModule;

public class GlassItemFrame
extends ItemFrame
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Boolean> IS_SHINY = SynchedEntityData.m_135353_(GlassItemFrame.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String TAG_SHINY = "isShiny";
    private static final GameProfile DUMMY_PROFILE = new GameProfile(UUID.randomUUID(), "ItemFrame");
    private boolean didHackery = false;
    private Integer onSignRotation = null;

    public GlassItemFrame(EntityType<? extends GlassItemFrame> type, Level worldIn) {
        super(type, worldIn);
    }

    public GlassItemFrame(Level worldIn, BlockPos blockPos, Direction face) {
        super(GlassItemFrameModule.glassFrameEntity, worldIn);
        this.f_31698_ = blockPos;
        this.m_6022_(face);
    }

    @Nonnull
    public InteractionResult m_6096_(Player player, @Nonnull InteractionHand hand) {
        BlockState behindState;
        InteractionResult result;
        BlockPos behind;
        BlockEntity tile;
        ItemStack item = this.m_31822_();
        if (!player.m_6144_() && !item.m_41619_() && !(item.m_41720_() instanceof BannerItem) && (tile = this.f_19853_.m_7702_(behind = this.getBehindPos())) != null && tile.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && (result = (behindState = this.f_19853_.m_8055_(behind)).m_60664_(this.f_19853_, player, hand, new BlockHitResult(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), this.f_31699_, behind, true))).m_19077_()) {
            return result;
        }
        InteractionResult res = super.m_6096_(player, hand);
        this.updateIsOnSign();
        return res;
    }

    public void m_8119_() {
        ItemStack stack;
        Item item;
        super.m_8119_();
        boolean shouldUpdateMaps = GlassItemFrameModule.glassItemFramesUpdateMapsEveryTick;
        if (this.f_19853_.m_46467_() % 100L == 0L) {
            this.updateIsOnSign();
            shouldUpdateMaps = true;
        }
        if (!this.f_19853_.f_46443_ && GlassItemFrameModule.glassItemFramesUpdateMaps && shouldUpdateMaps && (item = (stack = this.m_31822_()).m_41720_()) instanceof MapItem) {
            MapItem map = (MapItem)item;
            item = this.f_19853_;
            if (item instanceof ServerLevel) {
                ServerLevel sworld = (ServerLevel)item;
                ItemStack clone = stack.m_41777_();
                MapItemSavedData data = MapItem.m_42853_((ItemStack)clone, (Level)this.f_19853_);
                if (data != null && !data.f_77892_) {
                    FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)sworld, (GameProfile)DUMMY_PROFILE);
                    clone.m_41636_(null);
                    fakePlayer.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    fakePlayer.m_150109_().m_6836_(0, clone);
                    map.m_42893_(this.f_19853_, (Entity)fakePlayer, data);
                }
            }
        }
    }

    private void updateIsOnSign() {
        BlockState back;
        this.onSignRotation = null;
        if (this.f_31699_.m_122434_() != Direction.Axis.Y && (back = this.f_19853_.m_8055_(this.getBehindPos())).m_204336_(BlockTags.f_13066_)) {
            this.onSignRotation = (Integer)back.m_61143_((Property)StandingSignBlock.f_56987_);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SHINY, (Object)false);
    }

    public boolean m_7088_() {
        return this.isOnSign() || super.m_7088_();
    }

    public BlockPos getBehindPos() {
        return this.f_31698_.m_121945_(this.f_31699_.m_122424_());
    }

    public boolean isOnSign() {
        return this.onSignRotation != null;
    }

    public Integer getOnSignRotation() {
        return this.onSignRotation;
    }

    @Nullable
    public ItemEntity m_5552_(@Nonnull ItemStack stack, float offset) {
        if (stack.m_41720_() == Items.f_42617_ && !this.didHackery) {
            stack = new ItemStack((ItemLike)this.getDroppedItem());
            this.didHackery = true;
        }
        return super.m_5552_(stack, offset);
    }

    @Nonnull
    public ItemStack getPickedResult(HitResult target) {
        ItemStack held = this.m_31822_();
        if (held.m_41619_()) {
            return new ItemStack((ItemLike)this.getDroppedItem());
        }
        return held.m_41777_();
    }

    private Item getDroppedItem() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHINY) != false ? GlassItemFrameModule.glowingGlassFrame : GlassItemFrameModule.glassFrame;
    }

    public void m_7380_(@Nonnull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128379_(TAG_SHINY, ((Boolean)this.f_19804_.m_135370_(IS_SHINY)).booleanValue());
    }

    public void m_7378_(@Nonnull CompoundTag cmp) {
        super.m_7378_(cmp);
        this.f_19804_.m_135381_(IS_SHINY, (Object)cmp.m_128471_(TAG_SHINY));
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.f_31698_);
        buffer.m_130130_(this.f_31699_.m_122411_());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_31698_ = buffer.m_130135_();
        this.m_6022_(Direction.m_122376_((int)buffer.m_130242_()));
    }
}

